/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.IDeviceCertificate;

public enum AuthenticationSettings {
    INSTANCE;

    private static final int SECRET_RAW_KEY_LENGTH = 32;
    private byte[] mSecretKeyData = null;
    private String mBrokerPackageName = "com.microsoft.windowsintune.companyportal";
    private String mBrokerSignature = "1L4Z9FJCgn5c0VLhyAxC5O9LdlE=";
    private Class<?> mClazzDeviceCertProxy;
    private String mActivityPackageName;
    private String mSharedPrefPackageName;
    private boolean mSkipBroker = false;
    private int mExpirationBuffer = 300;
    private int mConnectTimeOut = 30000;
    private int mReadTimeOut = 30000;

    public byte[] getSecretKeyData() {
        return this.mSecretKeyData;
    }

    public void setSecretKey(byte[] rawKey) {
        if (rawKey == null || rawKey.length != 32) {
            throw new IllegalArgumentException("rawKey");
        }
        this.mSecretKeyData = rawKey;
    }

    public String getBrokerPackageName() {
        return this.mBrokerPackageName;
    }

    public void setBrokerPackageName(String packageName) {
        this.mBrokerPackageName = packageName;
    }

    public String getBrokerSignature() {
        return this.mBrokerSignature;
    }

    public void setBrokerSignature(String brokerSignature) {
        this.mBrokerSignature = brokerSignature;
    }

    public void setDeviceCertificateProxyClass(Class clazz) {
        if (!IDeviceCertificate.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("clazz");
        }
        this.mClazzDeviceCertProxy = clazz;
    }

    public Class<?> getDeviceCertificateProxy() {
        return this.mClazzDeviceCertProxy;
    }

    public String getActivityPackageName() {
        return this.mActivityPackageName;
    }

    public void setActivityPackageName(String activityPackageName) {
        this.mActivityPackageName = activityPackageName;
    }

    public boolean getSkipBroker() {
        return this.mSkipBroker;
    }

    public void setSkipBroker(boolean skip) {
        this.mSkipBroker = skip;
    }

    public void setSharedPrefPackageName(String packageNameForSharedFile) {
        this.mSharedPrefPackageName = packageNameForSharedFile;
    }

    public String getSharedPrefPackageName() {
        return this.mSharedPrefPackageName;
    }

    public int getExpirationBuffer() {
        return this.mExpirationBuffer;
    }

    public void setExpirationBuffer(int expirationBuffer) {
        this.mExpirationBuffer = expirationBuffer;
    }

    public int getConnectTimeOut() {
        return this.mConnectTimeOut;
    }

    public void setConnectTimeOut(int timeOutMillis) {
        if (timeOutMillis < 0) {
            throw new IllegalArgumentException("Invalid timeOutMillis");
        }
        this.mConnectTimeOut = timeOutMillis;
    }

    public int getReadTimeOut() {
        return this.mReadTimeOut;
    }

    public void setReadTimeOut(int timeOutMillis) {
        if (timeOutMillis < 0) {
            throw new IllegalArgumentException("Invalid timeOutMillis");
        }
        this.mReadTimeOut = timeOutMillis;
    }
}

