/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.net.Uri;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.HashMapExtensions;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.IDiscovery;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.WebRequestHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;

final class Discovery
implements IDiscovery {
    private static final String TAG = "Discovery";
    private static final String API_VERSION_KEY = "api-version";
    private static final String API_VERSION_VALUE = "1.0";
    private static final String AUTHORIZATION_ENDPOINT_KEY = "authorization_endpoint";
    private static final String INSTANCE_DISCOVERY_SUFFIX = "common/discovery/instance";
    private static final String AUTHORIZATION_COMMON_ENDPOINT = "/common/oauth2/authorize";
    private static final String TENANT_DISCOVERY_ENDPOINT = "tenant_discovery_endpoint";
    private static final Set<String> sValidHosts = Collections.synchronizedSet(new HashSet());
    private static final String TRUSTED_QUERY_INSTANCE = "login.windows.net";
    private UUID mCorrelationId;
    private IWebRequestHandler mWebrequestHandler;

    public Discovery() {
        this.initValidList();
        this.mWebrequestHandler = new WebRequestHandler();
    }

    @Override
    public boolean isValidAuthority(URL authorizationEndpoint) {
        if (authorizationEndpoint != null && !StringExtensions.IsNullOrBlank(authorizationEndpoint.getHost()) && authorizationEndpoint.getProtocol().equals("https") && StringExtensions.IsNullOrBlank(authorizationEndpoint.getQuery()) && StringExtensions.IsNullOrBlank(authorizationEndpoint.getRef()) && !StringExtensions.IsNullOrBlank(authorizationEndpoint.getPath())) {
            if (this.isADFSAuthority(authorizationEndpoint)) {
                throw new AuthenticationException(ADALError.DISCOVERY_NOT_SUPPORTED);
            }
            if (sValidHosts.contains(authorizationEndpoint.getHost().toLowerCase(Locale.US))) {
                return true;
            }
            return this.queryInstance(authorizationEndpoint);
        }
        return false;
    }

    private boolean isADFSAuthority(URL authorizationEndpoint) {
        String path = authorizationEndpoint.getPath();
        return !StringExtensions.IsNullOrBlank(path) && path.toLowerCase(Locale.ENGLISH).equals("/adfs");
    }

    private void addValidHostToList(URL validhost) {
        String validHost = validhost.getHost();
        if (!StringExtensions.IsNullOrBlank(validHost)) {
            sValidHosts.add(validHost.toLowerCase(Locale.US));
        }
    }

    private void initValidList() {
        if (sValidHosts.size() == 0) {
            sValidHosts.add(TRUSTED_QUERY_INSTANCE);
            sValidHosts.add("login.chinacloudapi.cn");
            sValidHosts.add("login.cloudgovapi.us");
        }
    }

    private boolean queryInstance(URL authorizationEndpointUrl) {
        boolean result = false;
        try {
            URL queryUrl = this.buildQueryString(TRUSTED_QUERY_INSTANCE, this.getAuthorizationCommonEndpoint(authorizationEndpointUrl));
            result = this.sendRequest(queryUrl);
        }
        catch (MalformedURLException e) {
            Logger.e(TAG, "Invalid authority", "", ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, e);
            result = false;
        }
        catch (JSONException e) {
            Logger.e(TAG, "Json parsing error", "", ADALError.DEVELOPER_AUTHORITY_CAN_NOT_BE_VALIDED, e);
            result = false;
        }
        if (result) {
            this.addValidHostToList(authorizationEndpointUrl);
        }
        return result;
    }

    private boolean sendRequest(URL queryUrl) throws MalformedURLException, JSONException {
        Logger.v(TAG, "Sending discovery request to:" + queryUrl);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        if (this.mCorrelationId != null) {
            headers.put("client-request-id", this.mCorrelationId.toString());
            headers.put("return-client-request-id", "true");
        }
        HttpWebResponse webResponse = null;
        try {
            webResponse = this.mWebrequestHandler.sendGet(queryUrl, headers);
            return this.parseResponse(webResponse);
        }
        catch (IllegalArgumentException exc) {
            Logger.e(TAG, exc.getMessage(), "", ADALError.DEVELOPER_AUTHORITY_CAN_NOT_BE_VALIDED, exc);
            throw exc;
        }
        catch (JSONException e) {
            Logger.e(TAG, "Json parsing error", "", ADALError.DEVELOPER_AUTHORITY_CAN_NOT_BE_VALIDED, e);
            throw e;
        }
    }

    private Boolean parseResponse(HttpWebResponse webResponse) throws JSONException {
        HashMap<String, String> response = HashMapExtensions.getJsonResponse(webResponse);
        return response != null && response.containsKey(TENANT_DISCOVERY_ENDPOINT);
    }

    private String getAuthorizationCommonEndpoint(URL authorizationEndpointUrl) throws MalformedURLException {
        return String.format("https://%s%s", authorizationEndpointUrl.getHost(), AUTHORIZATION_COMMON_ENDPOINT);
    }

    private URL buildQueryString(String instance, String authorizationEndpointUrl) throws MalformedURLException {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https").authority(instance);
        builder.appendEncodedPath(INSTANCE_DISCOVERY_SUFFIX);
        builder.appendQueryParameter(API_VERSION_KEY, API_VERSION_VALUE);
        builder.appendQueryParameter(AUTHORIZATION_ENDPOINT_KEY, authorizationEndpointUrl);
        return new URL(builder.build().toString());
    }

    @Override
    public void setCorrelationId(UUID requestCorrelationId) {
        this.mCorrelationId = requestCorrelationId;
    }
}

