/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.os.Handler;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AuthenticationParameters {
    public static final String AUTH_HEADER_MISSING_AUTHORITY = "WWW-Authenticate header is missing authorization_uri.";
    public static final String AUTH_HEADER_INVALID_FORMAT = "Invalid authentication header format";
    public static final String AUTH_HEADER_MISSING = "WWW-Authenticate header was expected in the response";
    public static final String AUTH_HEADER_WRONG_STATUS = "Unauthorized http response (status code 401) was expected";
    public static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String BEARER = "bearer";
    public static final String AUTHORITY_KEY = "authorization_uri";
    public static final String RESOURCE_KEY = "resource_id";
    private static final String TAG = "AuthenticationParameters";
    private String mAuthority;
    private String mResource;
    private static IWebRequestHandler sWebRequest = new WebRequestHandler();
    private static ExecutorService sThreadExecutor = Executors.newSingleThreadExecutor();

    public String getAuthority() {
        return this.mAuthority;
    }

    public String getResource() {
        return this.mResource;
    }

    public AuthenticationParameters() {
    }

    AuthenticationParameters(String authority, String resource) {
        this.mAuthority = authority;
        this.mResource = resource;
    }

    public static void createFromResourceUrl(Context context, final URL resourceUrl, final AuthenticationParamCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        Logger.d(TAG, "createFromResourceUrl");
        final Handler handler = new Handler(context.getMainLooper());
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Accept", "application/json");
                try {
                    HttpWebResponse webResponse = sWebRequest.sendGet(resourceUrl, headers);
                    if (webResponse != null) {
                        try {
                            this.onCompleted(null, AuthenticationParameters.parseResponse(webResponse));
                        }
                        catch (IllegalArgumentException exc) {
                            this.onCompleted(exc, null);
                        }
                    }
                }
                catch (Exception exception) {
                    this.onCompleted(exception, null);
                }
            }

            void onCompleted(final Exception exception, final AuthenticationParameters param) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCompleted(exception, param);
                    }
                });
            }
        });
    }

    public static AuthenticationParameters createFromResponseAuthenticateHeader(String authenticateHeader) {
        AuthenticationParameters authParams = null;
        if (StringExtensions.IsNullOrBlank(authenticateHeader)) {
            throw new IllegalArgumentException(AUTH_HEADER_MISSING);
        }
        if (!(authenticateHeader = authenticateHeader.trim().toLowerCase(Locale.US)).startsWith(BEARER) || authenticateHeader.length() < BEARER.length() + 2 || !Character.isWhitespace(authenticateHeader.charAt(BEARER.length()))) {
            throw new IllegalArgumentException(AUTH_HEADER_INVALID_FORMAT);
        }
        authenticateHeader = authenticateHeader.substring(BEARER.length());
        ArrayList<String> queryPairs = AuthenticationParameters.splitWithQuotes(authenticateHeader, ',');
        HashMap<String, String> headerItems = new HashMap<String, String>();
        for (String queryPair : queryPairs) {
            ArrayList<String> pair = AuthenticationParameters.splitWithQuotes(queryPair, '=');
            if (pair.size() == 2 && !StringExtensions.IsNullOrBlank(pair.get(0)) && !StringExtensions.IsNullOrBlank(pair.get(1))) {
                String key = pair.get(0);
                String value = pair.get(1);
                try {
                    key = StringExtensions.URLFormDecode(key);
                    value = StringExtensions.URLFormDecode(value);
                }
                catch (UnsupportedEncodingException e) {
                    Logger.d(TAG, e.getMessage());
                }
                key = key.trim();
                value = AuthenticationParameters.removeQuoteInHeaderValue(value.trim());
                if (headerItems.containsKey(key)) {
                    Logger.w(TAG, String.format("Key/value pair list contains redundant key '{0}'.", key), "", ADALError.DEVELOPER_BEARER_HEADER_MULTIPLE_ITEMS);
                }
                headerItems.put(key, value);
                continue;
            }
            throw new IllegalArgumentException(AUTH_HEADER_INVALID_FORMAT);
        }
        String authority = (String)headerItems.get(AUTHORITY_KEY);
        if (StringExtensions.IsNullOrBlank(authority)) {
            throw new IllegalArgumentException(AUTH_HEADER_MISSING_AUTHORITY);
        }
        authParams = new AuthenticationParameters(AuthenticationParameters.removeQuoteInHeaderValue(authority), AuthenticationParameters.removeQuoteInHeaderValue((String)headerItems.get(RESOURCE_KEY)));
        return authParams;
    }

    static ArrayList<String> splitWithQuotes(String input, char delimiter) {
        String item;
        ArrayList<String> items = new ArrayList<String>();
        int startIndex = 0;
        boolean insideString = false;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == delimiter && !insideString) {
                item = input.substring(startIndex, i);
                if (!StringExtensions.IsNullOrBlank(item.trim())) {
                    items.add(item);
                }
                startIndex = i + 1;
                continue;
            }
            if (input.charAt(i) != '\"') continue;
            insideString = !insideString;
        }
        item = input.substring(startIndex);
        if (!StringExtensions.IsNullOrBlank(item.trim())) {
            items.add(item);
        }
        return items;
    }

    private static String removeQuoteInHeaderValue(String value) {
        if (!StringExtensions.IsNullOrBlank(value)) {
            return value.replace("\"", "");
        }
        return null;
    }

    private static AuthenticationParameters parseResponse(HttpWebResponse webResponse) {
        if (webResponse.getStatusCode() == 401) {
            List<String> headers;
            Map<String, List<String>> responseHeaders = webResponse.getResponseHeaders();
            if (responseHeaders != null && responseHeaders.containsKey(AUTHENTICATE_HEADER) && (headers = responseHeaders.get(AUTHENTICATE_HEADER)) != null && headers.size() > 0) {
                return AuthenticationParameters.createFromResponseAuthenticateHeader(headers.get(0));
            }
            throw new IllegalArgumentException(AUTH_HEADER_MISSING);
        }
        throw new IllegalArgumentException(AUTH_HEADER_WRONG_STATUS);
    }

    public static interface AuthenticationParamCallback {
        public void onCompleted(Exception var1, AuthenticationParameters var2);
    }
}

