/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.os.Bundle;
import com.microsoft.aad.adal.IdToken;
import com.microsoft.aad.adal.StringExtensions;
import java.io.Serializable;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = 8790127561636702672L;
    private String mUserId;
    private String mGivenName;
    private String mFamilyName;
    private String mIdentityProvider;
    private boolean mIsUserIdDisplayable;
    private String mTenantId;

    public UserInfo() {
    }

    public UserInfo(String userid, String givenName, String familyName, String identityProvider, boolean isDisplayable) {
        this.mUserId = userid;
        this.mGivenName = givenName;
        this.mFamilyName = familyName;
        this.mIdentityProvider = identityProvider;
        this.mIsUserIdDisplayable = isDisplayable;
    }

    public UserInfo(IdToken token) {
        this.mIsUserIdDisplayable = false;
        if (token != null) {
            this.mTenantId = token.mTenantId;
            if (!StringExtensions.IsNullOrBlank(token.mUpn)) {
                this.mUserId = token.mUpn;
                this.mIsUserIdDisplayable = true;
            } else if (!StringExtensions.IsNullOrBlank(token.mEmail)) {
                this.mUserId = token.mEmail;
                this.mIsUserIdDisplayable = true;
            } else if (!StringExtensions.IsNullOrBlank(token.mSubject)) {
                this.mUserId = token.mSubject;
            }
            this.mGivenName = token.mGivenName;
            this.mFamilyName = token.mFamilyName;
            this.mIdentityProvider = token.mIdentityProvider;
        }
    }

    static UserInfo getUserInfoFromBrokerResult(Bundle bundle) {
        String userid = bundle.getString("account.userinfo.userid");
        String givenName = bundle.getString("account.userinfo.given.name");
        String familyName = bundle.getString("account.userinfo.family.name");
        String identityProvider = bundle.getString("account.userinfo.identity.provider");
        Boolean displayable = bundle.getBoolean("account.userinfo.userid.displayable", false);
        return new UserInfo(userid, givenName, familyName, identityProvider, displayable);
    }

    public String getUserId() {
        return this.mUserId;
    }

    public boolean getIsUserIdDisplayable() {
        return this.mIsUserIdDisplayable;
    }

    public String getGivenName() {
        return this.mGivenName;
    }

    public String getFamilyName() {
        return this.mFamilyName;
    }

    public String getIdentityProvider() {
        return this.mIdentityProvider;
    }

    public String getTenantId() {
        return this.mTenantId;
    }
}

