/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.securestorage;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.metallicus.protonsdk.R;
import com.metallicus.protonsdk.securestorage.KeystoreTool;
import com.metallicus.protonsdk.securestorage.SecretKeyTool;
import com.metallicus.protonsdk.securestorage.SecureStorageException;

public final class SecurePreferences {
    private static String SharedPreferencesName = "SecurePreferences";

    private SecurePreferences() {
    }

    public static String getSharedPreferencesName() {
        return SharedPreferencesName;
    }

    public static void setSharedPreferencesName(String sharedPreferencesName) {
        SharedPreferencesName = sharedPreferencesName;
    }

    public static void setValue(@NonNull Context context, @NonNull String key, @NonNull String value, @Nullable String password) throws SecureStorageException {
        Context applicationContext = context.getApplicationContext();
        String transformedValue = "";
        if (password != null) {
            transformedValue = SecretKeyTool.encryptMessage(key, value, password);
        } else {
            if (!KeystoreTool.keyPairExists()) {
                KeystoreTool.generateKeyPair(context);
            }
            transformedValue = KeystoreTool.encryptMessage(applicationContext, value);
        }
        if (TextUtils.isEmpty((CharSequence)transformedValue)) {
            throw new SecureStorageException(context.getString(R.string.secureStorageEncryptionError), null, SecureStorageException.ExceptionType.CRYPTO_EXCEPTION);
        }
        SecurePreferences.setSecureValue(context, key, transformedValue);
    }

    public static void setValue(@NonNull Context context, @NonNull String key, @NonNull String value) throws SecureStorageException {
        SecurePreferences.setValue(context, key, value, null);
    }

    public static void setValue(@NonNull Context context, @NonNull String key, boolean value, @Nullable String password) throws SecureStorageException {
        SecurePreferences.setValue(context, key, String.valueOf(value), password);
    }

    public static void setValue(@NonNull Context context, @NonNull String key, boolean value) throws SecureStorageException {
        SecurePreferences.setValue(context, key, value, null);
    }

    public static void setValue(@NonNull Context context, @NonNull String key, float value, @Nullable String password) throws SecureStorageException {
        SecurePreferences.setValue(context, key, String.valueOf(value), password);
    }

    public static void setValue(@NonNull Context context, @NonNull String key, float value) throws SecureStorageException {
        SecurePreferences.setValue(context, key, value, null);
    }

    public static void setValue(@NonNull Context context, @NonNull String key, long value, @Nullable String password) throws SecureStorageException {
        SecurePreferences.setValue(context, key, String.valueOf(value), password);
    }

    public static void setValue(@NonNull Context context, @NonNull String key, long value) throws SecureStorageException {
        SecurePreferences.setValue(context, key, value, null);
    }

    public static void setValue(@NonNull Context context, @NonNull String key, int value, @Nullable String password) throws SecureStorageException {
        SecurePreferences.setValue(context, key, String.valueOf(value), password);
    }

    public static void setValue(@NonNull Context context, @NonNull String key, int value) throws SecureStorageException {
        SecurePreferences.setValue(context, key, value, null);
    }

    @Nullable
    public static String getStringValue(@NonNull Context context, @NonNull String key, @Nullable String password, @Nullable String defValue) {
        String secureValue = SecurePreferences.getSecureValue(context, key);
        try {
            if (!TextUtils.isEmpty((CharSequence)secureValue)) {
                if (password != null) {
                    return SecretKeyTool.decryptMessage(key, secureValue, password);
                }
                return KeystoreTool.decryptMessage(context, secureValue);
            }
            return defValue;
        }
        catch (SecureStorageException e) {
            return defValue;
        }
    }

    @Nullable
    public static String getStringValue(@NonNull Context context, @NonNull String key, @Nullable String defValue) {
        return SecurePreferences.getStringValue(context, key, null, defValue);
    }

    public static boolean getBooleanValue(@NonNull Context context, @NonNull String key, @Nullable String password, boolean defValue) {
        return Boolean.parseBoolean(SecurePreferences.getStringValue(context, key, password, String.valueOf(defValue)));
    }

    public static boolean getBooleanValue(@NonNull Context context, @NonNull String key, boolean defValue) {
        return SecurePreferences.getBooleanValue(context, key, null, defValue);
    }

    public static float getFloatValue(@NonNull Context context, @NonNull String key, @Nullable String password, float defValue) {
        String stringVal = SecurePreferences.getStringValue(context, key, password, String.valueOf(defValue));
        if (stringVal != null) {
            return Float.parseFloat(stringVal);
        }
        return defValue;
    }

    public static float getFloatValue(@NonNull Context context, @NonNull String key, float defValue) {
        return SecurePreferences.getFloatValue(context, key, null, defValue);
    }

    public static long getLongValue(@NonNull Context context, @NonNull String key, @Nullable String password, long defValue) {
        String stringVal = SecurePreferences.getStringValue(context, key, password, String.valueOf(defValue));
        if (stringVal != null) {
            return Long.parseLong(stringVal);
        }
        return defValue;
    }

    public static long getLongValue(@NonNull Context context, @NonNull String key, long defValue) {
        return SecurePreferences.getLongValue(context, key, null, defValue);
    }

    public static int getIntValue(@NonNull Context context, @NonNull String key, @Nullable String password, int defValue) {
        String stringVal = SecurePreferences.getStringValue(context, key, password, String.valueOf(defValue));
        if (stringVal != null) {
            return Integer.parseInt(stringVal);
        }
        return defValue;
    }

    public static int getIntValue(@NonNull Context context, @NonNull String key, int defValue) {
        return SecurePreferences.getIntValue(context, key, null, defValue);
    }

    @NonNull
    public static SharedPreferences getSharedPreferences(@NonNull Context context) {
        return context.getSharedPreferences(SecurePreferences.getSharedPreferencesName(), 0);
    }

    public static boolean contains(@NonNull Context context, @NonNull String key) {
        return SecurePreferences.getSharedPreferences(context).contains(key);
    }

    public static void removeValue(@NonNull Context context, @NonNull String key) {
        SecurePreferences.removeSecureValue(context, key);
    }

    public static void clearAllValues(@NonNull Context context) throws SecureStorageException {
        SecurePreferences.clearAllSecureValues(context);
        KeystoreTool.deleteKeyPair();
    }

    private static void setSecureValue(@NonNull Context context, @NonNull String key, @NonNull String value) {
        SecurePreferences.getSharedPreferences(context).edit().putString(key, value).apply();
    }

    @Nullable
    private static String getSecureValue(@NonNull Context context, @NonNull String key) {
        return SecurePreferences.getSharedPreferences(context).getString(key, null);
    }

    private static void removeSecureValue(@NonNull Context context, @NonNull String key) {
        SecurePreferences.getSharedPreferences(context).edit().remove(key).apply();
    }

    private static void clearAllSecureValues(@NonNull Context context) {
        SecurePreferences.getSharedPreferences(context).edit().clear().apply();
    }
}

