/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.types;

import com.metallicus.protonsdk.eosio.commander.model.types.EosType;
import java.util.Arrays;

public class TypeName
implements EosType.Packer {
    private static final String CHAR_MAP = ".12345abcdefghijklmnopqrstuvwxyz";
    private static final int MAX_NAME_IDX = 12;
    private long mValue;

    static byte char_to_symbol(char c) {
        if (c >= 'a' && c <= 'z') {
            return (byte)(c - 97 + 6);
        }
        if (c >= '1' && c <= '5') {
            return (byte)(c - 49 + 1);
        }
        return 0;
    }

    public static long string_to_name(String str) {
        if (null == str) {
            return 0L;
        }
        int len = str.length();
        long value = 0L;
        for (int i = 0; i <= 12; ++i) {
            long c = 0L;
            if (i < len && i <= 12) {
                c = TypeName.char_to_symbol(str.charAt(i));
            }
            if (i < 12) {
                c &= 0x1FL;
                c <<= 64 - 5 * (i + 1);
            } else {
                c &= 0xFL;
            }
            value |= c;
        }
        return value;
    }

    public static String name_to_string(long nameAsLong) {
        long tmp = nameAsLong;
        char[] result = new char[13];
        Arrays.fill(result, ' ');
        for (int i = 0; i <= 12; ++i) {
            char c;
            result[12 - i] = c = CHAR_MAP.charAt((int)(tmp & (long)(i == 0 ? 15 : 31)));
            tmp >>= i == 0 ? 4 : 5;
        }
        return String.valueOf(result).replaceAll("[.]+$", "");
    }

    public TypeName(long nameAsLong) {
        this.mValue = nameAsLong;
    }

    public TypeName(String name) {
        this.mValue = TypeName.string_to_name(name);
    }

    @Override
    public void pack(EosType.Writer writer) {
        writer.putLongLE(this.mValue);
    }

    public String toString() {
        return TypeName.name_to_string(this.mValue);
    }
}

