/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.chain;

import com.google.gson.annotations.Expose;
import com.metallicus.protonsdk.eosio.commander.HexUtils;
import com.metallicus.protonsdk.eosio.commander.digest.Sha256;
import com.metallicus.protonsdk.eosio.commander.ec.EcDsa;
import com.metallicus.protonsdk.eosio.commander.ec.EcSignature;
import com.metallicus.protonsdk.eosio.commander.ec.EosPrivateKey;
import com.metallicus.protonsdk.eosio.commander.model.chain.Transaction;
import com.metallicus.protonsdk.eosio.commander.model.types.EosByteWriter;
import com.metallicus.protonsdk.eosio.commander.model.types.TypeChainId;
import java.util.ArrayList;
import java.util.List;

public class SignedTransaction
extends Transaction {
    @Expose
    private List<String> signatures = null;
    @Expose
    private List<String> context_free_data = new ArrayList<String>();

    public SignedTransaction() {
    }

    public SignedTransaction(Transaction anotherTxn) {
        super(anotherTxn);
    }

    public SignedTransaction(SignedTransaction anotherTxn) {
        super(anotherTxn);
        this.signatures = this.deepCopyOnlyContainer(anotherTxn.signatures);
        this.context_free_data = this.deepCopyOnlyContainer(anotherTxn.context_free_data);
    }

    public List<String> getSignatures() {
        return this.signatures;
    }

    public void putSignatures(List<String> signatures) {
        this.signatures = signatures;
    }

    public int getCtxFreeDataCount() {
        return this.context_free_data == null ? 0 : this.context_free_data.size();
    }

    public List<String> getCtxFreeData() {
        return this.context_free_data;
    }

    private byte[] getCfdHash() {
        if (this.context_free_data.size() <= 0) {
            return Sha256.ZERO_HASH.getBytes();
        }
        EosByteWriter writer = new EosByteWriter(255);
        writer.putVariableUInt(this.context_free_data.size());
        for (String hexData : this.context_free_data) {
            byte[] rawData = HexUtils.toBytes(hexData);
            writer.putVariableUInt(rawData.length);
            writer.putBytes(rawData);
        }
        return Sha256.from(writer.toBytes()).getBytes();
    }

    private Sha256 getDigestForSignature(TypeChainId chainId) {
        EosByteWriter writer = new EosByteWriter(255);
        writer.putBytes(chainId.getBytes());
        this.pack(writer);
        writer.putBytes(this.getCfdHash());
        return Sha256.from(writer.toBytes());
    }

    public void sign(EosPrivateKey privateKey, TypeChainId chainId) {
        if (null == this.signatures) {
            this.signatures = new ArrayList<String>();
        }
        EcSignature signature = EcDsa.sign(this.getDigestForSignature(chainId), privateKey);
        this.signatures.add(signature.toString());
    }
}

