/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.chain;

import com.google.gson.annotations.Expose;
import com.metallicus.protonsdk.eosio.commander.HexUtils;
import com.metallicus.protonsdk.eosio.commander.model.chain.SignedTransaction;
import com.metallicus.protonsdk.eosio.commander.model.chain.Transaction;
import com.metallicus.protonsdk.eosio.commander.model.types.EosByteWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class PackedTransaction {
    @Expose
    final List<String> signatures;
    @Expose
    final String compression;
    @Expose
    private String packed_context_free_data;
    @Expose
    private String packed_trx;

    public PackedTransaction(SignedTransaction stxn, CompressType compressType) {
        this.compression = compressType.name();
        this.signatures = stxn.getSignatures();
        this.packed_trx = HexUtils.toHex(this.packTransaction(stxn, compressType));
        byte[] packed_ctx_free_bytes = this.packContextFreeData(stxn.getCtxFreeData(), compressType);
        this.packed_context_free_data = packed_ctx_free_bytes.length == 0 ? "" : HexUtils.toHex(packed_ctx_free_bytes);
    }

    private byte[] packTransaction(Transaction transaction, CompressType compressType) {
        EosByteWriter byteWriter = new EosByteWriter(512);
        transaction.pack(byteWriter);
        return this.compress(byteWriter.toBytes(), compressType);
    }

    private byte[] packContextFreeData(List<String> ctxFreeData, CompressType compressType) {
        int ctxFreeDataCount;
        EosByteWriter byteWriter = new EosByteWriter(64);
        int n = ctxFreeDataCount = ctxFreeData == null ? 0 : ctxFreeData.size();
        if (ctxFreeDataCount == 0) {
            return byteWriter.toBytes();
        }
        byteWriter.putVariableUInt(ctxFreeDataCount);
        for (String hexData : ctxFreeData) {
            byteWriter.putBytes(HexUtils.toBytes(hexData));
        }
        return this.compress(byteWriter.toBytes(), compressType);
    }

    public PackedTransaction(SignedTransaction stxn) {
        this(stxn, CompressType.none);
    }

    public String getPackedTrx() {
        return this.packed_trx;
    }

    public List<String> getSignatures() {
        return this.signatures;
    }

    private byte[] compress(byte[] uncompressedBytes, CompressType compressType) {
        if (compressType == null || !CompressType.zlib.equals((Object)compressType)) {
            return uncompressedBytes;
        }
        Deflater deflater = new Deflater(9);
        deflater.setInput(uncompressedBytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(uncompressedBytes.length);
        deflater.finish();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        try {
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return uncompressedBytes;
        }
        return outputStream.toByteArray();
    }

    private byte[] decompress(byte[] compressedBytes) {
        Inflater inflater = new Inflater();
        inflater.setInput(compressedBytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(compressedBytes.length);
        byte[] buffer = new byte[1024];
        try {
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
        }
        catch (IOException | DataFormatException e) {
            e.printStackTrace();
            return compressedBytes;
        }
        return outputStream.toByteArray();
    }

    public static enum CompressType {
        none,
        zlib;

    }
}

