/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.ec;

import com.metallicus.protonsdk.eosio.commander.BitUtils;
import com.metallicus.protonsdk.eosio.commander.RefValue;
import com.metallicus.protonsdk.eosio.commander.digest.Ripemd160;
import com.metallicus.protonsdk.eosio.commander.ec.CurveParam;
import com.metallicus.protonsdk.eosio.commander.ec.EcTools;
import com.metallicus.protonsdk.eosio.commander.ec.EosEcUtil;
import java.util.Arrays;

public class EosPublicKey {
    private static final String LEGACY_PREFIX = "EOS";
    private static final String PREFIX = "PUB";
    private static final int CHECK_BYTE_LEN = 4;
    private final long mCheck;
    private final CurveParam mCurveParam;
    private final byte[] mData;

    public EosPublicKey(byte[] data) {
        this(data, EcTools.getCurveParam(0));
    }

    public EosPublicKey(byte[] data, CurveParam curveParam) {
        this.mData = Arrays.copyOf(data, 33);
        this.mCurveParam = curveParam;
        this.mCheck = BitUtils.uint32ToLong(Ripemd160.from(this.mData, 0, this.mData.length).bytes(), 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EosPublicKey(String base58Str) {
        RefValue<Long> checksumRef = new RefValue<Long>();
        String[] parts = EosEcUtil.safeSplitEosCryptoString(base58Str);
        if (base58Str.startsWith(LEGACY_PREFIX)) {
            if (parts.length != 1) throw new IllegalEosPubkeyFormatException(base58Str);
            this.mCurveParam = EcTools.getCurveParam(0);
            this.mData = EosEcUtil.getBytesIfMatchedRipemd160(base58Str.substring(LEGACY_PREFIX.length()), null, checksumRef);
        } else {
            if (parts.length < 3) {
                throw new IllegalEosPubkeyFormatException(base58Str);
            }
            if (!PREFIX.equals(parts[0])) {
                throw new IllegalEosPubkeyFormatException(base58Str);
            }
            this.mCurveParam = EosEcUtil.getCurveParamFrom(parts[1]);
            this.mData = EosEcUtil.getBytesIfMatchedRipemd160(parts[2], parts[1], checksumRef);
        }
        this.mCheck = (Long)checksumRef.data;
    }

    public byte[] getBytes() {
        return this.mData;
    }

    public String toString() {
        boolean isR1 = this.mCurveParam.isType(1);
        return EosEcUtil.encodeEosCrypto(isR1 ? PREFIX : LEGACY_PREFIX, isR1 ? this.mCurveParam : null, this.mData);
    }

    public int hashCode() {
        return (int)(this.mCheck & 0xFFFFFFFFL);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (null == other || this.getClass() != other.getClass()) {
            return false;
        }
        return BitUtils.areEqual(this.mData, ((EosPublicKey)other).mData);
    }

    public boolean isCurveParamK1() {
        return this.mCurveParam == null || 0 == this.mCurveParam.getCurveParamType();
    }

    public static class IllegalEosPubkeyFormatException
    extends IllegalArgumentException {
        public IllegalEosPubkeyFormatException(String pubkeyStr) {
            super("invalid eos public key : " + pubkeyStr);
        }
    }
}

