/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.ec;

import com.metallicus.protonsdk.eosio.commander.ec.CurveParam;
import com.metallicus.protonsdk.eosio.commander.ec.EcPoint;
import java.math.BigInteger;

public class EcTools {
    private static CurveParam[] sCurveParams = new CurveParam[2];

    public static CurveParam getCurveParam(int curveType) {
        if (curveType < 0 || sCurveParams.length <= curveType) {
            throw new IllegalArgumentException("Unknown Curve Type: " + curveType);
        }
        if (null == sCurveParams[curveType]) {
            if (0 == curveType) {
                EcTools.sCurveParams[0] = new CurveParam(0, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F", "0", "7", "79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798", "483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141");
            } else if (1 == curveType) {
                EcTools.sCurveParams[1] = new CurveParam(1, "ffffffff00000001000000000000000000000000ffffffffffffffffffffffff", "ffffffff00000001000000000000000000000000fffffffffffffffffffffffc", "5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", "6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", "4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5", "ffffffff00000000ffffffffffffffffbce6faada7179e84f3b9cac2fc632551");
            }
        }
        return sCurveParams[curveType];
    }

    public static int getByteLength(int fieldSize) {
        return (fieldSize + 7) / 8;
    }

    public static byte[] integerToBytes(BigInteger s, int length) {
        byte[] bytes = s.toByteArray();
        if (length < bytes.length) {
            byte[] tmp = new byte[length];
            System.arraycopy(bytes, bytes.length - tmp.length, tmp, 0, tmp.length);
            return tmp;
        }
        if (length > bytes.length) {
            byte[] tmp = new byte[length];
            System.arraycopy(bytes, 0, tmp, tmp.length - bytes.length, bytes.length);
            return tmp;
        }
        return bytes;
    }

    public static EcPoint multiply(EcPoint p, BigInteger k) {
        BigInteger e = k;
        BigInteger h = e.multiply(BigInteger.valueOf(3L));
        EcPoint neg = p.negate();
        EcPoint R2 = p;
        for (int i = h.bitLength() - 2; i > 0; --i) {
            boolean eBit;
            R2 = R2.twice();
            boolean hBit = h.testBit(i);
            if (hBit == (eBit = e.testBit(i))) continue;
            R2 = R2.add(hBit ? p : neg);
        }
        return R2;
    }

    public static EcPoint sumOfTwoMultiplies(EcPoint P, BigInteger k, EcPoint Q, BigInteger l) {
        int m = Math.max(k.bitLength(), l.bitLength());
        EcPoint Z = P.add(Q);
        EcPoint R2 = P.getCurve().getInfinity();
        for (int i = m - 1; i >= 0; --i) {
            R2 = R2.twice();
            if (k.testBit(i)) {
                if (l.testBit(i)) {
                    R2 = R2.add(Z);
                    continue;
                }
                R2 = R2.add(P);
                continue;
            }
            if (!l.testBit(i)) continue;
            R2 = R2.add(Q);
        }
        return R2;
    }

    public static EcPoint decompressKey(CurveParam param, BigInteger x, boolean firstBit) {
        int size = 1 + EcTools.getByteLength(param.getCurve().getFieldSize());
        byte[] dest = EcTools.integerToBytes(x, size);
        dest[0] = (byte)(firstBit ? 3 : 2);
        return param.getCurve().decodePoint(dest);
    }
}

