/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.ec;

import java.math.BigInteger;
import java.util.Random;

public class EcFieldElement {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private BigInteger _x;
    private BigInteger _q;

    public EcFieldElement(BigInteger q, BigInteger x) {
        this._x = x;
        if (x.compareTo(q) >= 0) {
            throw new IllegalArgumentException("x value too large in field element");
        }
        this._q = q;
    }

    public BigInteger toBigInteger() {
        return this._x;
    }

    public int getFieldSize() {
        return this._q.bitLength();
    }

    public BigInteger getQ() {
        return this._q;
    }

    public EcFieldElement add(EcFieldElement b) {
        return new EcFieldElement(this._q, this._x.add(b.toBigInteger()).mod(this._q));
    }

    public EcFieldElement subtract(EcFieldElement b) {
        return new EcFieldElement(this._q, this._x.subtract(b.toBigInteger()).mod(this._q));
    }

    public EcFieldElement multiply(EcFieldElement b) {
        return new EcFieldElement(this._q, this._x.multiply(b.toBigInteger()).mod(this._q));
    }

    public EcFieldElement divide(EcFieldElement b) {
        return new EcFieldElement(this._q, this._x.multiply(b.toBigInteger().modInverse(this._q)).mod(this._q));
    }

    public EcFieldElement negate() {
        return new EcFieldElement(this._q, this._x.negate().mod(this._q));
    }

    public EcFieldElement square() {
        return new EcFieldElement(this._q, this._x.multiply(this._x).mod(this._q));
    }

    public EcFieldElement invert() {
        return new EcFieldElement(this._q, this._x.modInverse(this._q));
    }

    public String toString() {
        return this.toBigInteger().toString(16);
    }

    public EcFieldElement sqrt() {
        if (!this._q.testBit(0)) {
            throw new RuntimeException("not done yet");
        }
        if (this._q.testBit(1)) {
            EcFieldElement z = new EcFieldElement(this._q, this._x.modPow(this._q.shiftRight(2).add(BigInteger.ONE), this._q));
            return z.square().equals(this) ? z : null;
        }
        BigInteger qMinusOne = this._q.subtract(BigInteger.ONE);
        BigInteger legendreExponent = qMinusOne.shiftRight(1);
        if (!this._x.modPow(legendreExponent, this._q).equals(BigInteger.ONE)) {
            return null;
        }
        BigInteger u = qMinusOne.shiftRight(2);
        BigInteger k = u.shiftLeft(1).add(BigInteger.ONE);
        BigInteger Q = this._x;
        BigInteger fourQ = Q.shiftLeft(2).mod(this._q);
        Random rand = new Random();
        while (true) {
            BigInteger P;
            if ((P = new BigInteger(this._q.bitLength(), rand)).compareTo(this._q) >= 0 || !P.multiply(P).subtract(fourQ).modPow(legendreExponent, this._q).equals(qMinusOne)) {
                continue;
            }
            BigInteger[] result = EcFieldElement.lucasSequence(this._q, P, Q, k);
            BigInteger U = result[0];
            BigInteger V = result[1];
            if (V.multiply(V).mod(this._q).equals(fourQ)) {
                if (V.testBit(0)) {
                    V = V.add(this._q);
                }
                V = V.shiftRight(1);
                return new EcFieldElement(this._q, V);
            }
            if (!U.equals(BigInteger.ONE) && !U.equals(qMinusOne)) break;
        }
        return null;
    }

    private static BigInteger[] lucasSequence(BigInteger p, BigInteger P, BigInteger Q, BigInteger k) {
        int j;
        int n = k.bitLength();
        int s = k.getLowestSetBit();
        BigInteger Uh = BigInteger.ONE;
        BigInteger Vl = TWO;
        BigInteger Vh = P;
        BigInteger Ql = BigInteger.ONE;
        BigInteger Qh = BigInteger.ONE;
        for (j = n - 1; j >= s + 1; --j) {
            Ql = Ql.multiply(Qh).mod(p);
            if (k.testBit(j)) {
                Qh = Ql.multiply(Q).mod(p);
                Uh = Uh.multiply(Vh).mod(p);
                Vl = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p);
                Vh = Vh.multiply(Vh).subtract(Qh.shiftLeft(1)).mod(p);
                continue;
            }
            Qh = Ql;
            Uh = Uh.multiply(Vl).subtract(Ql).mod(p);
            Vh = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p);
            Vl = Vl.multiply(Vl).subtract(Ql.shiftLeft(1)).mod(p);
        }
        Ql = Ql.multiply(Qh).mod(p);
        Qh = Ql.multiply(Q).mod(p);
        Uh = Uh.multiply(Vl).subtract(Ql).mod(p);
        Vl = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p);
        Ql = Ql.multiply(Qh).mod(p);
        for (j = 1; j <= s; ++j) {
            Uh = Uh.multiply(Vl).mod(p);
            Vl = Vl.multiply(Vl).subtract(Ql.shiftLeft(1)).mod(p);
            Ql = Ql.multiply(Ql).mod(p);
        }
        return new BigInteger[]{Uh, Vl};
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EcFieldElement)) {
            return false;
        }
        EcFieldElement o = (EcFieldElement)other;
        return this._q.equals(o._q) && this._x.equals(o._x);
    }

    public int hashCode() {
        return this._q.hashCode() ^ this._x.hashCode();
    }
}

