/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.ec;

import com.google.common.base.Preconditions;
import com.metallicus.protonsdk.eosio.commander.Hmac;
import com.metallicus.protonsdk.eosio.commander.digest.Sha256;
import com.metallicus.protonsdk.eosio.commander.ec.CurveParam;
import com.metallicus.protonsdk.eosio.commander.ec.EcCurve;
import com.metallicus.protonsdk.eosio.commander.ec.EcPoint;
import com.metallicus.protonsdk.eosio.commander.ec.EcSignature;
import com.metallicus.protonsdk.eosio.commander.ec.EcTools;
import com.metallicus.protonsdk.eosio.commander.ec.EosPrivateKey;
import com.metallicus.protonsdk.eosio.commander.ec.EosPublicKey;
import com.metallicus.protonsdk.eosio.commander.model.types.EosByteWriter;
import java.math.BigInteger;
import java.util.Arrays;

public class EcDsa {
    private static BigInteger deterministicGenerateK(CurveParam curveParam, byte[] hash, BigInteger d, SigChecker checker, int nonce) {
        if (nonce > 0) {
            hash = Sha256.from(hash, BigInteger.valueOf(nonce).toByteArray()).getBytes();
        }
        byte[] dBytes = d.toByteArray();
        byte[] v = new byte[32];
        Arrays.fill(v, (byte)1);
        byte[] k = new byte[32];
        Arrays.fill(k, (byte)0);
        EosByteWriter bwD = new EosByteWriter(97);
        bwD.putBytes(v);
        bwD.put((byte)0);
        bwD.putBytes(dBytes);
        bwD.putBytes(hash);
        k = Hmac.hmacSha256(k, bwD.toBytes());
        v = Hmac.hmacSha256(k, v);
        EosByteWriter bwF = new EosByteWriter(97);
        bwF.putBytes(v);
        bwF.put((byte)1);
        bwF.putBytes(dBytes);
        bwF.putBytes(hash);
        k = Hmac.hmacSha256(k, bwF.toBytes());
        v = Hmac.hmacSha256(k, v);
        v = Hmac.hmacSha256(k, v);
        BigInteger t = new BigInteger(1, v);
        while (t.signum() <= 0 || t.compareTo(curveParam.n()) >= 0 || !checker.checkSignature(curveParam, t)) {
            EosByteWriter bwH = new EosByteWriter(33);
            bwH.putBytes(v);
            bwH.put((byte)0);
            k = Hmac.hmacSha256(k, bwH.toBytes());
            v = Hmac.hmacSha256(k, v);
            v = Hmac.hmacSha256(k, v);
            t = new BigInteger(v);
        }
        return t;
    }

    public static EcSignature sign(Sha256 hash, EosPrivateKey key) {
        BigInteger privAsBI = key.getAsBigInteger();
        SigChecker checker = new SigChecker(hash.getBytes(), privAsBI);
        CurveParam curveParam = key.getCurveParam();
        int nonce = 0;
        do {
            EcDsa.deterministicGenerateK(curveParam, hash.getBytes(), privAsBI, checker, nonce++);
            if (checker.s.compareTo(curveParam.halfCurveOrder()) <= 0) continue;
            checker.s = curveParam.n().subtract(checker.s);
        } while (!checker.isRSEachLength(32));
        EcSignature signature = new EcSignature(checker.r, checker.s, curveParam);
        byte[] data = hash.getBytes();
        EosPublicKey pubKey = key.getPublicKey();
        for (int i = 0; i < 4; ++i) {
            EosPublicKey recovered = EcDsa.recoverPubKey(curveParam, data, signature, i);
            if (!pubKey.equals(recovered)) continue;
            signature.setRecid(i);
            break;
        }
        if (signature.recId < 0) {
            throw new IllegalStateException("could not find recid. Was this data signed with this key?");
        }
        return signature;
    }

    public static EosPublicKey recoverPubKey(byte[] messageSigned, EcSignature signature) {
        return EcDsa.recoverPubKey(signature.curveParam, messageSigned, signature, signature.recId);
    }

    public static EosPublicKey recoverPubKey(CurveParam curveParam, byte[] messageSigned, EcSignature signature, int recId) {
        Preconditions.checkArgument((recId >= 0 ? 1 : 0) != 0, (Object)"recId must be positive");
        Preconditions.checkArgument((signature.r.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0, (Object)"r must be positive");
        Preconditions.checkArgument((signature.s.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0, (Object)"s must be positive");
        Preconditions.checkNotNull((Object)messageSigned);
        BigInteger n = curveParam.n();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = signature.r.add(i.multiply(n));
        EcCurve curve = curveParam.getCurve();
        BigInteger prime = curve.getQ();
        if (x.compareTo(prime) >= 0) {
            return null;
        }
        EcPoint R2 = EcTools.decompressKey(curveParam, x, (recId & 1) == 1);
        if (!R2.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, messageSigned);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = signature.r.modInverse(n);
        BigInteger srInv = rInv.multiply(signature.s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        EcPoint q = EcTools.sumOfTwoMultiplies(curveParam.G(), eInvrInv, R2, srInv);
        q = new EcPoint(curve, q.getX(), q.getY(), true);
        return new EosPublicKey(q.getEncoded());
    }

    private static boolean isSignerOf(CurveParam curveParam, byte[] messageSigned, int recId, EcSignature sig, byte[] pubKeyBytes) {
        Preconditions.checkArgument((recId >= 0 ? 1 : 0) != 0, (Object)"recId must be positive");
        Preconditions.checkArgument((sig.r.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0, (Object)"r must be positive");
        Preconditions.checkArgument((sig.s.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0, (Object)"s must be positive");
        Preconditions.checkNotNull((Object)messageSigned);
        BigInteger n = curveParam.n();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = sig.r.add(i.multiply(n));
        EcCurve curve = curveParam.getCurve();
        BigInteger prime = curve.getQ();
        if (x.compareTo(prime) >= 0) {
            return false;
        }
        EcPoint R2 = EcTools.decompressKey(curveParam, x, (recId & 1) == 1);
        if (!R2.multiply(n).isInfinity()) {
            return false;
        }
        BigInteger e = new BigInteger(1, messageSigned);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = sig.r.modInverse(n);
        BigInteger srInv = rInv.multiply(sig.s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        EcPoint q = EcTools.sumOfTwoMultiplies(curveParam.G(), eInvrInv, R2, srInv);
        q = new EcPoint(curve, q.getX(), q.getY(), true);
        byte[] recoveredPub = q.getEncoded();
        return Arrays.equals(recoveredPub, pubKeyBytes);
    }

    private static class SigChecker {
        BigInteger e;
        BigInteger privKey;
        BigInteger r;
        BigInteger s;

        SigChecker(byte[] hash, BigInteger privKey) {
            this.e = new BigInteger(1, hash);
            this.privKey = privKey;
        }

        boolean checkSignature(CurveParam curveParam, BigInteger k) {
            EcPoint Q = EcTools.multiply(curveParam.G(), k);
            if (Q.isInfinity()) {
                return false;
            }
            this.r = Q.getX().toBigInteger().mod(curveParam.n());
            if (this.r.signum() == 0) {
                return false;
            }
            this.s = k.modInverse(curveParam.n()).multiply(this.e.add(this.privKey.multiply(this.r))).mod(curveParam.n());
            return this.s.signum() != 0;
        }

        public boolean isRSEachLength(int length) {
            return this.r.toByteArray().length == length && this.s.toByteArray().length == length;
        }
    }
}

