/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.ec;

import com.metallicus.protonsdk.eosio.commander.ec.EcFieldElement;
import com.metallicus.protonsdk.eosio.commander.ec.EcPoint;
import java.math.BigInteger;

public class EcCurve {
    private EcFieldElement _a;
    private EcFieldElement _b;
    private BigInteger _q;
    private EcPoint _infinity;

    public EcCurve(BigInteger q, BigInteger a, BigInteger b) {
        this._q = q;
        this._a = this.fromBigInteger(a);
        this._b = this.fromBigInteger(b);
        this._infinity = new EcPoint(this, null, null);
    }

    public EcFieldElement getA() {
        return this._a;
    }

    public EcFieldElement getB() {
        return this._b;
    }

    public BigInteger getQ() {
        return this._q;
    }

    public EcPoint getInfinity() {
        return this._infinity;
    }

    public int getFieldSize() {
        return this._q.bitLength();
    }

    public EcFieldElement fromBigInteger(BigInteger x) {
        return new EcFieldElement(this._q, x);
    }

    public EcPoint decodePoint(byte[] encodedPoint) {
        EcPoint p = null;
        switch (encodedPoint[0]) {
            case 0: {
                p = this.getInfinity();
                break;
            }
            case 2: 
            case 3: {
                int bit0;
                int ytilde = encodedPoint[0] & 1;
                byte[] i = new byte[encodedPoint.length - 1];
                System.arraycopy(encodedPoint, 1, i, 0, i.length);
                EcFieldElement x = new EcFieldElement(this._q, new BigInteger(1, i));
                EcFieldElement alpha = x.multiply(x.square().add(this._a)).add(this._b);
                EcFieldElement beta = alpha.sqrt();
                if (beta == null) {
                    throw new RuntimeException("Invalid compression");
                }
                int n = bit0 = beta.toBigInteger().testBit(0) ? 1 : 0;
                if (bit0 == ytilde) {
                    p = new EcPoint(this, x, beta, true);
                    break;
                }
                p = new EcPoint(this, x, new EcFieldElement(this._q, this._q.subtract(beta.toBigInteger())), true);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                byte[] xEnc = new byte[(encodedPoint.length - 1) / 2];
                byte[] yEnc = new byte[(encodedPoint.length - 1) / 2];
                System.arraycopy(encodedPoint, 1, xEnc, 0, xEnc.length);
                System.arraycopy(encodedPoint, xEnc.length + 1, yEnc, 0, yEnc.length);
                p = new EcPoint(this, new EcFieldElement(this._q, new BigInteger(1, xEnc)), new EcFieldElement(this._q, new BigInteger(1, yEnc)));
                break;
            }
            default: {
                throw new RuntimeException("Invalid encoding 0x" + Integer.toString(encodedPoint[0], 16));
            }
        }
        return p;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EcCurve)) {
            return false;
        }
        EcCurve other = (EcCurve)obj;
        return this._q.equals(other._q) && this._a.equals(other._a) && this._b.equals(other._b);
    }

    public int hashCode() {
        return this._a.hashCode() ^ this._b.hashCode() ^ this._q.hashCode();
    }
}

