/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.ec;

import com.metallicus.protonsdk.eosio.commander.HexUtils;
import com.metallicus.protonsdk.eosio.commander.ec.EcCurve;
import com.metallicus.protonsdk.eosio.commander.ec.EcPoint;
import java.math.BigInteger;

public class CurveParam {
    public static final int SECP256_K1 = 0;
    public static final int SECP256_R1 = 1;
    private final int curveParamType;
    private final EcCurve curve;
    private final EcPoint G;
    private final BigInteger n;
    private final BigInteger HALF_CURVE_ORDER;

    public CurveParam(int curveParamType, String pInHex, String aInHex, String bInHex, String GxInHex, String GyInHex, String nInHex) {
        this.curveParamType = curveParamType;
        BigInteger p = new BigInteger(pInHex, 16);
        BigInteger b = new BigInteger(bInHex, 16);
        BigInteger a = new BigInteger(aInHex, 16);
        this.curve = new EcCurve(p, a, b);
        this.G = this.curve.decodePoint(HexUtils.toBytes("04" + GxInHex + GyInHex));
        this.n = new BigInteger(nInHex, 16);
        this.HALF_CURVE_ORDER = this.n.shiftRight(1);
    }

    public int getCurveParamType() {
        return this.curveParamType;
    }

    public boolean isType(int paramType) {
        return this.curveParamType == paramType;
    }

    public EcPoint G() {
        return this.G;
    }

    public BigInteger n() {
        return this.n;
    }

    public BigInteger halfCurveOrder() {
        return this.HALF_CURVE_ORDER;
    }

    public EcCurve getCurve() {
        return this.curve;
    }
}

