/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.digest;

import com.google.common.base.Preconditions;
import com.metallicus.protonsdk.eosio.commander.HexUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class Sha256 {
    public static final int HASH_LENGTH = 32;
    public static final Sha256 ZERO_HASH = new Sha256(new byte[32]);
    private final byte[] mHashBytes;

    public Sha256(byte[] bytes) {
        Preconditions.checkArgument((bytes.length == 32 ? 1 : 0) != 0);
        this.mHashBytes = bytes;
    }

    public static MessageDigest getSha256Digest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static Sha256 from(byte[] data) {
        MessageDigest digest = Sha256.getSha256Digest();
        digest.update(data, 0, data.length);
        return new Sha256(digest.digest());
    }

    public static Sha256 from(byte[] data, int offset, int length) {
        MessageDigest digest = Sha256.getSha256Digest();
        digest.update(data, offset, length);
        return new Sha256(digest.digest());
    }

    public static Sha256 from(byte[] data1, byte[] data2) {
        MessageDigest digest = Sha256.getSha256Digest();
        digest.update(data1, 0, data1.length);
        digest.update(data2, 0, data2.length);
        return new Sha256(digest.digest());
    }

    public static Sha256 doubleHash(byte[] data, int offset, int length) {
        MessageDigest digest = Sha256.getSha256Digest();
        digest.update(data, offset, length);
        return new Sha256(digest.digest(digest.digest()));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Sha256)) {
            return false;
        }
        return Arrays.equals(this.mHashBytes, ((Sha256)other).mHashBytes);
    }

    public String toString() {
        return HexUtils.toHex(this.mHashBytes);
    }

    public byte[] getBytes() {
        return this.mHashBytes;
    }

    public boolean equalsFromOffset(byte[] toCompareData, int offsetInCompareData, int len) {
        if (null == toCompareData || offsetInCompareData < 0 || len < 0 || this.mHashBytes.length <= len || toCompareData.length <= offsetInCompareData) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.mHashBytes[i] == toCompareData[offsetInCompareData + i]) continue;
            return false;
        }
        return true;
    }

    public int length() {
        return 32;
    }
}

