/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.metallicus.protonsdk.eosio.commander.GsonEosTypeAdapterFactory;
import java.io.Closeable;

public class Utils {
    public static void closeSilently(Closeable c) {
        if (null != c) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static long parseLongSafely(String content, int defaultValue) {
        if (null == content) {
            return defaultValue;
        }
        try {
            return Long.parseLong(content);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int parseIntSafely(String content, int defaultValue) {
        if (null == content) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(content);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String prettyPrintJson(Object object) {
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonEosTypeAdapterFactory()).excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create().toJson(object);
    }
}

