/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitUtils {
    public static long uint16ToLong(byte[] buf, int offset) {
        return (long)buf[offset++] & 0xFFL | ((long)buf[offset++] & 0xFFL) << 8;
    }

    public static long uint32ToLong(byte[] buf, int offset) {
        return (long)buf[offset++] & 0xFFL | ((long)buf[offset++] & 0xFFL) << 8 | ((long)buf[offset++] & 0xFFL) << 16 | ((long)buf[offset] & 0xFFL) << 24;
    }

    public static long uint64ToLong(byte[] buf, int offset) {
        return (long)buf[offset++] & 0xFFL | ((long)buf[offset++] & 0xFFL) << 8 | ((long)buf[offset++] & 0xFFL) << 16 | ((long)buf[offset++] & 0xFFL) << 24 | ((long)buf[offset++] & 0xFFL) << 32 | ((long)buf[offset++] & 0xFFL) << 40 | ((long)buf[offset++] & 0xFFL) << 48 | ((long)buf[offset++] & 0xFFL) << 56;
    }

    public static int uint16FromStream(DataInputStream stream) throws IOException {
        return (int)((long)stream.read() & 0xFFL | ((long)stream.read() & 0xFFL) << 8);
    }

    public static int uint16FromStreamBE(DataInputStream stream) throws IOException {
        return (int)(((long)stream.read() & 0xFFL) << 8 | (long)stream.read() & 0xFFL);
    }

    public static int uint32FromStream(DataInputStream stream) throws IOException {
        return (int)((long)stream.read() & 0xFFL | ((long)stream.read() & 0xFFL) << 8 | ((long)stream.read() & 0xFFL) << 16 | ((long)stream.read() & 0xFFL) << 24);
    }

    public static long uint64FromStream(DataInputStream stream) throws IOException {
        return (long)stream.read() & 0xFFL | ((long)stream.read() & 0xFFL) << 8 | ((long)stream.read() & 0xFFL) << 16 | ((long)stream.read() & 0xFFL) << 24 | ((long)stream.read() & 0xFFL) << 32 | ((long)stream.read() & 0xFFL) << 40 | ((long)stream.read() & 0xFFL) << 48 | ((long)stream.read() & 0xFFL) << 56;
    }

    public static void uint32ToStream(long value, OutputStream stream) throws IOException {
        stream.write((byte)(0xFFL & value));
        stream.write((byte)(0xFFL & value >> 8));
        stream.write((byte)(0xFFL & value >> 16));
        stream.write((byte)(0xFFL & value >> 24));
    }

    public static void uint64ToStream(long value, OutputStream stream) throws IOException {
        stream.write((byte)(0xFFL & value));
        stream.write((byte)(0xFFL & value >> 8));
        stream.write((byte)(0xFFL & value >> 16));
        stream.write((byte)(0xFFL & value >> 24));
        stream.write((byte)(0xFFL & value >> 32));
        stream.write((byte)(0xFFL & value >> 40));
        stream.write((byte)(0xFFL & value >> 48));
        stream.write((byte)(0xFFL & value >> 56));
    }

    public static void uint32ToByteArrayLE(long value, byte[] output, int offset) {
        output[offset] = (byte)(0xFFL & value);
        output[offset + 1] = (byte)(0xFFL & value >> 8);
        output[offset + 2] = (byte)(0xFFL & value >> 16);
        output[offset + 3] = (byte)(0xFFL & value >> 24);
    }

    public static void uint64ToByteArrayLE(long value, byte[] output, int offset) {
        output[offset] = (byte)(0xFFL & value);
        output[offset + 1] = (byte)(0xFFL & value >> 8);
        output[offset + 2] = (byte)(0xFFL & value >> 16);
        output[offset + 3] = (byte)(0xFFL & value >> 24);
        output[offset + 4] = (byte)(0xFFL & value >> 32);
        output[offset + 5] = (byte)(0xFFL & value >> 40);
        output[offset + 6] = (byte)(0xFFL & value >> 48);
        output[offset + 7] = (byte)(0xFFL & value >> 56);
    }

    public static boolean areEqual(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] copyByteArray(byte[] source) {
        byte[] buf = new byte[source.length];
        System.arraycopy(source, 0, buf, 0, buf.length);
        return buf;
    }

    public static byte[] reverseBytes(byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buf[i] = bytes[bytes.length - 1 - i];
        }
        return buf;
    }

    public static byte[] readBytes(DataInputStream stream, int size) throws IOException {
        int read;
        byte[] buf = new byte[size];
        int done = 0;
        for (int toRead = size; toRead > 0; toRead -= read) {
            read = stream.read(buf, done, toRead);
            if (read == -1) {
                throw new IOException();
            }
            done += read;
        }
        return buf;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        if (newLength < 0) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[newLength];
        int lastIndex = Math.min(original.length, newLength);
        System.arraycopy(original, 0, buf, 0, lastIndex);
        return buf;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        if (to < from || from < 0 || from > original.length) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[to - from];
        int lastIndex = Math.min(original.length, to);
        System.arraycopy(original, from, buf, 0, lastIndex - from);
        return buf;
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }
}

