/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird.objects.voicecalls;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum SipResponseCode {
    OK,
    FORBIDDEN,
    NOT_FOUND,
    REQUEST_TIMEOUT,
    GONE,
    TEMPORARILY_UNAVAILABLE,
    ADDRESS_INCOMPLETE,
    BUSY_HERE,
    NOT_ACCEPTABLE_HERE,
    INTERNAL_SERVER_ERROR,
    NOT_IMPLEMENTED,
    BAD_GATEWAY,
    SERVICE_UNAVAILABLE;


    @JsonCreator
    public static SipResponseCode forValue(Integer value) {
        switch (value) {
            case 200: {
                return OK;
            }
            case 403: {
                return FORBIDDEN;
            }
            case 404: {
                return NOT_FOUND;
            }
            case 408: {
                return REQUEST_TIMEOUT;
            }
            case 410: {
                return GONE;
            }
            case 480: {
                return TEMPORARILY_UNAVAILABLE;
            }
            case 484: {
                return ADDRESS_INCOMPLETE;
            }
            case 486: {
                return BUSY_HERE;
            }
            case 488: {
                return NOT_ACCEPTABLE_HERE;
            }
            case 500: {
                return INTERNAL_SERVER_ERROR;
            }
            case 501: {
                return NOT_IMPLEMENTED;
            }
            case 502: {
                return BAD_GATEWAY;
            }
            case 503: {
                return SERVICE_UNAVAILABLE;
            }
        }
        throw new IllegalArgumentException("Unknown sip response code: " + value);
    }
}

