/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird.objects.conversations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public enum MessageComponentType {
    HEADER("header"),
    BODY("body"),
    FOOTER("footer"),
    BUTTON("button"),
    CARD("card"),
    CAROUSEL("carousel"),
    LIMITED_TIME_OFFER("limited_time_offer");

    private static final Map<String, MessageComponentType> TYPE_MAP;
    private final String type;

    private MessageComponentType(String type) {
        this.type = type;
    }

    @JsonCreator
    public static MessageComponentType forValue(String value) {
        Objects.requireNonNull(value, "Value cannot be null");
        return TYPE_MAP.get(value.toLowerCase(Locale.ROOT));
    }

    @JsonValue
    public String toJson() {
        return this.getType();
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.getType();
    }

    static {
        HashMap<String, MessageComponentType> map = new HashMap<String, MessageComponentType>();
        for (MessageComponentType componentType : MessageComponentType.values()) {
            map.put(componentType.getType().toLowerCase(), componentType);
        }
        TYPE_MAP = Collections.unmodifiableMap(map);
    }
}

