/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import com.mercadopago.client.payment.PaymentCategoryDescriptorRequest;
import java.math.BigDecimal;
import java.time.OffsetDateTime;

public class PaymentItemRequest {
    private final String id;
    private final String title;
    private final String description;
    private final String pictureUrl;
    private final String categoryId;
    private final Integer quantity;
    private final BigDecimal unitPrice;
    private final PaymentCategoryDescriptorRequest categoryDescriptor;
    private final boolean warranty;
    private final OffsetDateTime eventDate;

    PaymentItemRequest(String id, String title, String description, String pictureUrl, String categoryId, Integer quantity, BigDecimal unitPrice, PaymentCategoryDescriptorRequest categoryDescriptor, boolean warranty, OffsetDateTime eventDate) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.pictureUrl = pictureUrl;
        this.categoryId = categoryId;
        this.quantity = quantity;
        this.unitPrice = unitPrice;
        this.categoryDescriptor = categoryDescriptor;
        this.warranty = warranty;
        this.eventDate = eventDate;
    }

    public static PaymentItemRequestBuilder builder() {
        return new PaymentItemRequestBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public PaymentCategoryDescriptorRequest getCategoryDescriptor() {
        return this.categoryDescriptor;
    }

    public boolean isWarranty() {
        return this.warranty;
    }

    public OffsetDateTime getEventDate() {
        return this.eventDate;
    }

    public static class PaymentItemRequestBuilder {
        private String id;
        private String title;
        private String description;
        private String pictureUrl;
        private String categoryId;
        private Integer quantity;
        private BigDecimal unitPrice;
        private PaymentCategoryDescriptorRequest categoryDescriptor;
        private boolean warranty;
        private OffsetDateTime eventDate;

        PaymentItemRequestBuilder() {
        }

        public PaymentItemRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PaymentItemRequestBuilder title(String title) {
            this.title = title;
            return this;
        }

        public PaymentItemRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public PaymentItemRequestBuilder pictureUrl(String pictureUrl) {
            this.pictureUrl = pictureUrl;
            return this;
        }

        public PaymentItemRequestBuilder categoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public PaymentItemRequestBuilder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public PaymentItemRequestBuilder unitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public PaymentItemRequestBuilder categoryDescriptor(PaymentCategoryDescriptorRequest categoryDescriptor) {
            this.categoryDescriptor = categoryDescriptor;
            return this;
        }

        public PaymentItemRequestBuilder warranty(boolean warranty) {
            this.warranty = warranty;
            return this;
        }

        public PaymentItemRequestBuilder eventDate(OffsetDateTime eventDate) {
            this.eventDate = eventDate;
            return this;
        }

        public PaymentItemRequest build() {
            return new PaymentItemRequest(this.id, this.title, this.description, this.pictureUrl, this.categoryId, this.quantity, this.unitPrice, this.categoryDescriptor, this.warranty, this.eventDate);
        }

        public String toString() {
            return "PaymentItemRequest.PaymentItemRequestBuilder(id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", pictureUrl=" + this.pictureUrl + ", categoryId=" + this.categoryId + ", quantity=" + this.quantity + ", unitPrice=" + this.unitPrice + ", categoryDescriptor=" + this.categoryDescriptor + ", warranty=" + this.warranty + ", eventDate=" + this.eventDate + ")";
        }
    }
}

