/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.cardtoken;

public class CardTokenRequest {
    private final String cardId;
    private final String customerId;
    private final String securityCode;

    CardTokenRequest(String cardId, String customerId, String securityCode) {
        this.cardId = cardId;
        this.customerId = customerId;
        this.securityCode = securityCode;
    }

    public static CardTokenRequestBuilder builder() {
        return new CardTokenRequestBuilder();
    }

    public String getCardId() {
        return this.cardId;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public static class CardTokenRequestBuilder {
        private String cardId;
        private String customerId;
        private String securityCode;

        CardTokenRequestBuilder() {
        }

        public CardTokenRequestBuilder cardId(String cardId) {
            this.cardId = cardId;
            return this;
        }

        public CardTokenRequestBuilder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public CardTokenRequestBuilder securityCode(String securityCode) {
            this.securityCode = securityCode;
            return this;
        }

        public CardTokenRequest build() {
            return new CardTokenRequest(this.cardId, this.customerId, this.securityCode);
        }

        public String toString() {
            return "CardTokenRequest.CardTokenRequestBuilder(cardId=" + this.cardId + ", customerId=" + this.customerId + ", securityCode=" + this.securityCode + ")";
        }
    }
}

