/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.preference;

import java.time.OffsetDateTime;

public class PreferenceRouteRequest {
    private final String departure;
    private final String destination;
    private final OffsetDateTime departureDateTime;
    private final OffsetDateTime arrivalDateTime;
    private final String company;

    PreferenceRouteRequest(String departure, String destination, OffsetDateTime departureDateTime, OffsetDateTime arrivalDateTime, String company) {
        this.departure = departure;
        this.destination = destination;
        this.departureDateTime = departureDateTime;
        this.arrivalDateTime = arrivalDateTime;
        this.company = company;
    }

    public static PreferenceRouteRequestBuilder builder() {
        return new PreferenceRouteRequestBuilder();
    }

    public String getDeparture() {
        return this.departure;
    }

    public String getDestination() {
        return this.destination;
    }

    public OffsetDateTime getDepartureDateTime() {
        return this.departureDateTime;
    }

    public OffsetDateTime getArrivalDateTime() {
        return this.arrivalDateTime;
    }

    public String getCompany() {
        return this.company;
    }

    public static class PreferenceRouteRequestBuilder {
        private String departure;
        private String destination;
        private OffsetDateTime departureDateTime;
        private OffsetDateTime arrivalDateTime;
        private String company;

        PreferenceRouteRequestBuilder() {
        }

        public PreferenceRouteRequestBuilder departure(String departure) {
            this.departure = departure;
            return this;
        }

        public PreferenceRouteRequestBuilder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public PreferenceRouteRequestBuilder departureDateTime(OffsetDateTime departureDateTime) {
            this.departureDateTime = departureDateTime;
            return this;
        }

        public PreferenceRouteRequestBuilder arrivalDateTime(OffsetDateTime arrivalDateTime) {
            this.arrivalDateTime = arrivalDateTime;
            return this;
        }

        public PreferenceRouteRequestBuilder company(String company) {
            this.company = company;
            return this;
        }

        public PreferenceRouteRequest build() {
            return new PreferenceRouteRequest(this.departure, this.destination, this.departureDateTime, this.arrivalDateTime, this.company);
        }

        public String toString() {
            return "PreferenceRouteRequest.PreferenceRouteRequestBuilder(departure=" + this.departure + ", destination=" + this.destination + ", departureDateTime=" + this.departureDateTime + ", arrivalDateTime=" + this.arrivalDateTime + ", company=" + this.company + ")";
        }
    }
}

