/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import java.math.BigDecimal;

public class PaymentCaptureRequest {
    private final boolean capture = true;
    private final BigDecimal transactionAmount;

    PaymentCaptureRequest(BigDecimal transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public static PaymentCaptureRequestBuilder builder() {
        return new PaymentCaptureRequestBuilder();
    }

    public boolean isCapture() {
        return this.capture;
    }

    public BigDecimal getTransactionAmount() {
        return this.transactionAmount;
    }

    public static class PaymentCaptureRequestBuilder {
        private BigDecimal transactionAmount;

        PaymentCaptureRequestBuilder() {
        }

        public PaymentCaptureRequestBuilder transactionAmount(BigDecimal transactionAmount) {
            this.transactionAmount = transactionAmount;
            return this;
        }

        public PaymentCaptureRequest build() {
            return new PaymentCaptureRequest(this.transactionAmount);
        }

        public String toString() {
            return "PaymentCaptureRequest.PaymentCaptureRequestBuilder(transactionAmount=" + this.transactionAmount + ")";
        }
    }
}

