/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.util;

import android.support.annotation.NonNull;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public final class JsonUtil {
    private static JsonUtil mInstance = null;
    private final Gson mGson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).serializeNulls().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();

    private JsonUtil() {
    }

    public static JsonUtil getInstance() {
        if (mInstance == null) {
            mInstance = new JsonUtil();
        }
        return mInstance;
    }

    public <T> T fromJson(@NonNull String json, @NonNull Class<T> classOfT) {
        return (T)this.mGson.fromJson(json, classOfT);
    }

    public <T> T fromJson(@NonNull String json, @NonNull Type classOfT) {
        return (T)this.mGson.fromJson(json, classOfT);
    }

    private Map<String, Object> getMapFromJson(@NonNull String json) {
        return (Map)new Gson().fromJson(json, new TypeToken<HashMap<String, Object>>(){}.getType());
    }

    public Map<String, Object> getMapFromObject(Object src) {
        return this.getMapFromJson(this.mGson.toJson(src));
    }

    public String toJson(Object src) {
        return this.mGson.toJson(src);
    }

    public Gson getGson() {
        return this.mGson;
    }
}

