/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.model.PayerCost;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AmountConfiguration
implements Serializable,
Parcelable {
    public static final int NO_SELECTED = -1;
    public final int selectedPayerCostIndex;
    public final List<PayerCost> payerCosts;
    public final String discountToken;
    public static final Parcelable.Creator<AmountConfiguration> CREATOR = new Parcelable.Creator<AmountConfiguration>(){

        public AmountConfiguration createFromParcel(Parcel in) {
            return new AmountConfiguration(in);
        }

        public AmountConfiguration[] newArray(int size) {
            return new AmountConfiguration[size];
        }
    };

    public AmountConfiguration(int selectedPayerCostIndex, @Nullable List<PayerCost> payerCosts, @Nullable String discountToken) {
        this.selectedPayerCostIndex = selectedPayerCostIndex;
        this.payerCosts = payerCosts;
        this.discountToken = discountToken;
    }

    protected AmountConfiguration(Parcel in) {
        this.selectedPayerCostIndex = in.readInt();
        this.payerCosts = in.createTypedArrayList(PayerCost.CREATOR);
        this.discountToken = in.readString();
    }

    @NonNull
    public List<PayerCost> getPayerCosts() {
        return this.payerCosts == null ? new ArrayList() : this.payerCosts;
    }

    public int getDefaultPayerCostIndex() {
        return this.selectedPayerCostIndex;
    }

    @Nullable
    public String getDiscountToken() {
        return this.discountToken;
    }

    public PayerCost getPayerCost(int userSelectedPayerCost) {
        if (userSelectedPayerCost == -1) {
            return this.payerCosts.get(this.selectedPayerCostIndex);
        }
        return this.payerCosts.get(userSelectedPayerCost);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.selectedPayerCostIndex);
        dest.writeTypedList(this.payerCosts);
        dest.writeString(this.discountToken);
    }
}

