/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.core;

import android.content.Context;
import android.net.ConnectivityManager;
import android.support.annotation.NonNull;
import com.mercadopago.android.px.model.exceptions.NoConnectivityException;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;

public class ConnectivityStateInterceptor
implements Interceptor {
    @NonNull
    private final Context context;

    public ConnectivityStateInterceptor(@NonNull Context context) {
        this.context = context.getApplicationContext();
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        try {
            if (!connectivityManager.getActiveNetworkInfo().isAvailable() || !connectivityManager.getActiveNetworkInfo().isConnected()) {
                throw new NoConnectivityException();
            }
            return chain.proceed(chain.request());
        }
        catch (NullPointerException e) {
            throw new NoConnectivityException();
        }
    }
}

