/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.mercadopago.android.px.model.Agreement;
import com.mercadopago.android.px.model.ProcessingMode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PayerCost
implements Parcelable,
Serializable {
    public static final int NO_SELECTED = -1;
    @NonNull
    private Integer installments;
    private static final String CFT = "CFT";
    private static final String TEA = "TEA";
    private List<String> labels;
    private String recommendedMessage;
    private BigDecimal installmentRate;
    private BigDecimal totalAmount;
    private BigDecimal installmentAmount;
    private ProcessingMode processingMode;
    private List<Agreement> agreements;
    @Nullable
    private String paymentMethodOptionId;
    public static final Parcelable.Creator<PayerCost> CREATOR = new Parcelable.Creator<PayerCost>(){

        public PayerCost createFromParcel(Parcel in) {
            return new PayerCost(in);
        }

        public PayerCost[] newArray(int size) {
            return new PayerCost[size];
        }
    };

    @NonNull
    public Integer getInstallments() {
        return this.installments;
    }

    public BigDecimal getInstallmentRate() {
        return this.installmentRate;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public BigDecimal getInstallmentAmount() {
        return this.installmentAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public String getTEAPercent() {
        return this.getRates().get(TEA);
    }

    public String getCFTPercent() {
        return this.getRates().get(CFT);
    }

    public Map<String, String> getRates() {
        HashMap<String, String> ratesMap = new HashMap<String, String>();
        if (this.hasValidLabels()) {
            for (String label : this.labels) {
                String[] ratesRaw;
                if (!label.contains(CFT) && !label.contains(TEA)) continue;
                for (String rate : ratesRaw = label.split("\\|")) {
                    String[] rates = rate.split("_");
                    ratesMap.put(rates[0], rates[1]);
                }
            }
        }
        return ratesMap;
    }

    private boolean hasValidLabels() {
        return this.labels != null && !this.labels.isEmpty();
    }

    public boolean hasMultipleInstallments() {
        return this.installments != null && this.installments > 1;
    }

    @NonNull
    public ProcessingMode getProcessingMode() {
        return this.processingMode == null ? ProcessingMode.AGGREGATOR : this.processingMode;
    }

    @NonNull
    public List<Agreement> getAgreements() {
        return this.agreements == null ? Collections.emptyList() : this.agreements;
    }

    @Nullable
    public String getPaymentMethodOptionId() {
        return this.paymentMethodOptionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PayerCost)) {
            return false;
        }
        PayerCost payerCost = (PayerCost)o;
        if (!this.installments.equals(payerCost.installments)) {
            return false;
        }
        if (!this.totalAmount.equals(payerCost.totalAmount)) {
            return false;
        }
        return this.installmentAmount.equals(payerCost.installmentAmount);
    }

    public int hashCode() {
        int result = this.installments.hashCode();
        result = 31 * result + this.totalAmount.hashCode();
        result = 31 * result + this.installmentAmount.hashCode();
        return result;
    }

    public String toString() {
        return this.installments.toString();
    }

    public static PayerCost getPayerCost(@NonNull List<PayerCost> payerCosts, int userSelectedPayerCost, int defaultSelected) {
        if (userSelectedPayerCost == -1) {
            return payerCosts.get(defaultSelected);
        }
        return payerCosts.get(userSelectedPayerCost);
    }

    @Deprecated
    @VisibleForTesting
    public PayerCost() {
    }

    @Deprecated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Deprecated
    public void setInstallments(@NonNull Integer installments) {
        this.installments = installments;
    }

    @Deprecated
    public void setInstallmentRate(BigDecimal installmentRate) {
        this.installmentRate = installmentRate;
    }

    @Deprecated
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @Deprecated
    public Boolean hasRates() {
        return this.hasTEA() != false && this.hasCFT() != false;
    }

    @Deprecated
    public Boolean hasCFT() {
        return this.getCFTPercent() != null;
    }

    @Deprecated
    public Boolean hasTEA() {
        return this.getTEAPercent() != null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.installments.intValue());
        dest.writeStringList(this.labels);
        dest.writeString(this.recommendedMessage);
        if (this.installmentRate == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.installmentRate.toString());
        }
        if (this.totalAmount == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.totalAmount.toString());
        }
        if (this.installmentAmount == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.installmentAmount.toString());
        }
        dest.writeParcelable((Parcelable)this.processingMode, flags);
        dest.writeTypedList(this.agreements);
        dest.writeString(this.paymentMethodOptionId);
    }

    protected PayerCost(Parcel in) {
        this.installments = in.readInt();
        this.labels = in.createStringArrayList();
        this.recommendedMessage = in.readString();
        this.installmentRate = in.readByte() == 0 ? null : new BigDecimal(in.readString());
        this.totalAmount = in.readByte() == 0 ? null : new BigDecimal(in.readString());
        this.installmentAmount = in.readByte() == 0 ? null : new BigDecimal(in.readString());
        this.processingMode = (ProcessingMode)in.readParcelable(ProcessingMode.class.getClassLoader());
        this.agreements = in.createTypedArrayList(Agreement.CREATOR);
        this.paymentMethodOptionId = in.readString();
    }
}

