/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.core;

import android.content.Context;
import android.support.annotation.NonNull;
import com.mercadopago.android.px.internal.core.ApplicationModule;
import com.mercadopago.android.px.internal.core.ProductIdProvider;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class ProductIdInterceptor
implements Interceptor {
    private static final String HEADER_KEY = "X-Product-Id";
    @NonNull
    private final ProductIdProvider productIdProvider;

    public ProductIdInterceptor(@NonNull Context context) {
        this.productIdProvider = new ApplicationModule(context).getProductIdProvider();
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        Request request = originalRequest.newBuilder().header(HEADER_KEY, this.productIdProvider.getProductId()).build();
        return chain.proceed(request);
    }
}

