/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.PluralsRes;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import com.mercadopago.android.px.internal.util.textformatter.MatcherUtil;
import java.util.regex.Pattern;

public final class TextUtil {
    public static final String EMPTY = "";
    public static final String NL = "\n";
    public static final String DOT = ".";
    public static final CharSequence SPACE = " ";
    public static final CharSequence UNDERSCORE = "_";
    private static final String CSV_DELIMITER = ",";
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d+");
    private static final Pattern PLACE_HOLDER_PATTERN = Pattern.compile("\\{[0-9]*\\}");

    private TextUtil() {
        throw new AssertionError((Object)"Util classes shouldn't be instantiated.");
    }

    public static boolean isEmpty(@Nullable CharSequence text) {
        return text == null || text.length() <= 0;
    }

    public static boolean isNotEmpty(@Nullable CharSequence text) {
        return !TextUtil.isEmpty(text);
    }

    public static boolean isDigitsOnly(@Nullable CharSequence text) {
        return text != null && DIGIT_PATTERN.matcher(text).matches();
    }

    public static <T extends CharSequence> T ifNotEmptyOrElse(@Nullable T text, @NonNull T fallback) {
        return TextUtil.isNotEmpty(text) ? text : fallback;
    }

    @NonNull
    public static String join(@Nullable Iterable<String> values) {
        return values != null ? TextUtils.join((CharSequence)CSV_DELIMITER, values) : EMPTY;
    }

    public static String format(@NonNull Context context, @StringRes int resId, CharSequence ... args) {
        return resId == 0 ? EMPTY : TextUtil.format(context.getString(resId), args);
    }

    public static String format(@NonNull Context context, @PluralsRes int resId, int quantity, String ... args) {
        return resId == 0 ? EMPTY : TextUtil.format(context.getResources().getQuantityString(resId, quantity), args);
    }

    public static String format(@NonNull String text, CharSequence ... args) {
        if (args.length != MatcherUtil.count(PLACE_HOLDER_PATTERN, text)) {
            throw new IllegalStateException("There is a different amount of placeholder than arguments");
        }
        String result = text;
        for (int i = 0; i < args.length; ++i) {
            result = result.replace("{" + i + "}", args[i]);
        }
        return result;
    }
}

