/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.model.PayerCost;
import com.mercadopago.android.px.model.Split;
import java.io.Serializable;
import java.util.List;

@Keep
public final class AmountConfiguration
implements Serializable {
    private static final int NO_SELECTED_PAYER_COST = -1;
    private int selectedPayerCostIndex;
    @NonNull
    private List<PayerCost> payerCosts;
    @Nullable
    private Split split;
    @Nullable
    private String discountToken;

    @NonNull
    public List<PayerCost> getPayerCosts() {
        return this.payerCosts;
    }

    public boolean allowSplit() {
        return this.split != null;
    }

    @NonNull
    public List<PayerCost> getAppliedPayerCost(boolean userWantToSplit) {
        if (this.isSplitPossible(userWantToSplit)) {
            return this.getSplitConfiguration().primaryPaymentMethod.getPayerCosts();
        }
        return this.getPayerCosts();
    }

    @NonNull
    public PayerCost getCurrentPayerCost(boolean userWantToSplit, int userSelectedIndex) {
        if (this.isSplitPossible(userWantToSplit)) {
            return PayerCost.getPayerCost(this.getSplitConfiguration().primaryPaymentMethod.getPayerCosts(), userSelectedIndex, this.getSplitConfiguration().primaryPaymentMethod.selectedPayerCostIndex);
        }
        return PayerCost.getPayerCost(this.getPayerCosts(), userSelectedIndex, this.selectedPayerCostIndex);
    }

    @Nullable
    public Split getSplitConfiguration() {
        return this.split;
    }

    @Nullable
    public String getDiscountToken() {
        return this.discountToken;
    }

    @Nullable
    public PayerCost getPayerCost(int userSelectedPayerCost) {
        if (userSelectedPayerCost == -1) {
            return this.payerCosts.get(this.selectedPayerCostIndex);
        }
        return this.payerCosts.get(userSelectedPayerCost);
    }

    private boolean isSplitPossible(boolean userWantToSplit) {
        return userWantToSplit && this.allowSplit();
    }
}

