/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.util;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public final class ObjectMapTypeAdapter
extends TypeAdapter<Object> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() == HashMap.class) {
                return new ObjectMapTypeAdapter(gson);
            }
            return null;
        }
    };
    private final Gson gson;

    private ObjectMapTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public Object read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                in.beginArray();
                while (in.hasNext()) {
                    list.add(this.read(in));
                }
                in.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedTreeMap map = new LinkedTreeMap();
                in.beginObject();
                while (in.hasNext()) {
                    map.put(in.nextName(), this.read(in));
                }
                in.endObject();
                return map;
            }
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                String s = in.nextString();
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    Log.d((String)ObjectMapTypeAdapter.class.getCanonicalName(), (String)e.getLocalizedMessage());
                    try {
                        return Long.parseLong(s);
                    }
                    catch (NumberFormatException e2) {
                        Log.d((String)ObjectMapTypeAdapter.class.getCanonicalName(), (String)e2.getLocalizedMessage());
                        try {
                            return new BigDecimal(s);
                        }
                        catch (NumberFormatException e3) {
                            Log.d((String)ObjectMapTypeAdapter.class.getCanonicalName(), (String)e3.getLocalizedMessage());
                        }
                    }
                }
            }
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public void write(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        TypeAdapter typeAdapter = this.gson.getAdapter(value.getClass());
        if (typeAdapter instanceof ObjectMapTypeAdapter) {
            out.beginObject();
            out.endObject();
            return;
        }
        typeAdapter.write(out, value);
    }
}

