/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.model.Campaign;
import com.mercadopago.android.px.model.Discount;
import java.math.BigDecimal;

public class DiscountConfigurationModel
implements Parcelable {
    public static final DiscountConfigurationModel NONE = new DiscountConfigurationModel(null, null, true);
    private final Discount discount;
    private final Campaign campaign;
    private final boolean isAvailable;
    public static final Parcelable.Creator<DiscountConfigurationModel> CREATOR = new Parcelable.Creator<DiscountConfigurationModel>(){

        public DiscountConfigurationModel createFromParcel(Parcel in) {
            return new DiscountConfigurationModel(in);
        }

        public DiscountConfigurationModel[] newArray(int size) {
            return new DiscountConfigurationModel[size];
        }
    };

    public DiscountConfigurationModel(@Nullable Discount discount, @Nullable Campaign campaign, boolean isAvailable) {
        this.discount = discount;
        this.campaign = campaign;
        this.isAvailable = isAvailable;
    }

    protected DiscountConfigurationModel(Parcel in) {
        this.discount = (Discount)in.readParcelable(Discount.class.getClassLoader());
        this.campaign = (Campaign)in.readParcelable(Campaign.class.getClassLoader());
        this.isAvailable = in.readByte() != 0;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean hasValidDiscount() {
        return this.discount != null && this.campaign != null;
    }

    public BigDecimal getAmountWithDiscount(BigDecimal amount) {
        if (this.hasValidDiscount()) {
            return this.discount.getAmountWithDiscount(amount);
        }
        return amount;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.discount, flags);
        dest.writeParcelable((Parcelable)this.campaign, flags);
        dest.writeByte((byte)(this.isAvailable ? 1 : 0));
    }
}

