/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.mercadopago.android.px.model.Bin;
import com.mercadopago.android.px.model.CardNumber;
import com.mercadopago.android.px.model.SecurityCode;
import java.io.Serializable;
import java.util.List;

public class Setting
implements Parcelable,
Serializable {
    private Bin bin;
    private CardNumber cardNumber;
    private SecurityCode securityCode;
    public static final Parcelable.Creator<Setting> CREATOR = new Parcelable.Creator<Setting>(){

        public Setting createFromParcel(Parcel in) {
            return new Setting(in);
        }

        public Setting[] newArray(int size) {
            return new Setting[size];
        }
    };

    public Bin getBin() {
        return this.bin;
    }

    public void setBin(Bin bin) {
        this.bin = bin;
    }

    public CardNumber getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(CardNumber cardNumber) {
        this.cardNumber = cardNumber;
    }

    public SecurityCode getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(SecurityCode securityCode) {
        this.securityCode = securityCode;
    }

    public static Setting getSettingByBin(List<Setting> settings, String bin) {
        Setting selectedSetting = null;
        if (settings != null && settings.size() > 0) {
            for (Setting setting : settings) {
                if ("".equals(bin) || !bin.matches(setting.getBin().getPattern() + ".*") || setting.getBin().getExclusionPattern() != null && !setting.getBin().getExclusionPattern().isEmpty() && bin.matches(setting.getBin().getExclusionPattern() + ".*")) continue;
                selectedSetting = setting;
            }
        }
        return selectedSetting;
    }

    protected Setting(Parcel in) {
        this.bin = (Bin)in.readParcelable(Bin.class.getClassLoader());
        this.cardNumber = (CardNumber)in.readParcelable(CardNumber.class.getClassLoader());
        this.securityCode = (SecurityCode)in.readParcelable(SecurityCode.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.bin, flags);
        dest.writeParcelable((Parcelable)this.cardNumber, flags);
        dest.writeParcelable((Parcelable)this.securityCode, flags);
    }
}

