/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import com.mercadopago.android.px.internal.util.ParcelableUtil;
import com.mercadopago.android.px.internal.util.TextUtil;
import com.mercadopago.android.px.model.ExitAction;
import com.mercadopago.android.px.model.ExternalFragment;
import com.mercadopago.android.px.model.IPayment;

public class BusinessPayment
implements IPayment,
Parcelable {
    @NonNull
    private final String title;
    @NonNull
    private final Decorator decorator;
    @NonNull
    private final String paymentStatus;
    @NonNull
    private final String paymentStatusDetail;
    private final boolean shouldShowPaymentMethod;
    private final int iconId;
    @Nullable
    private final String help;
    @Nullable
    private final ExitAction exitActionPrimary;
    @Nullable
    private final ExitAction exitActionSecondary;
    @Nullable
    private final String statementDescription;
    @Nullable
    private final String receiptId;
    @Nullable
    private final String imageUrl;
    @Nullable
    private final ExternalFragment topFragment;
    @Nullable
    private final ExternalFragment bottomFragment;
    @Nullable
    private final String subtitle;
    public static final Parcelable.Creator<BusinessPayment> CREATOR = new Parcelable.Creator<BusinessPayment>(){

        public BusinessPayment createFromParcel(Parcel in) {
            return new BusinessPayment(in);
        }

        public BusinessPayment[] newArray(int size) {
            return new BusinessPayment[size];
        }
    };

    BusinessPayment(Builder builder) {
        this.help = builder.help;
        this.title = builder.title;
        this.decorator = builder.decorator;
        this.iconId = builder.iconId;
        this.shouldShowPaymentMethod = builder.shouldShowPaymentMethod;
        this.exitActionPrimary = builder.buttonPrimary;
        this.exitActionSecondary = builder.buttonSecondary;
        this.statementDescription = builder.statementDescription;
        this.receiptId = builder.receiptId;
        this.imageUrl = builder.imageUrl;
        this.topFragment = builder.topFragment;
        this.bottomFragment = builder.bottomFragment;
        this.paymentStatus = builder.paymentStatus;
        this.paymentStatusDetail = builder.paymentStatusDetail;
        this.subtitle = builder.subtitle;
    }

    protected BusinessPayment(Parcel in) {
        this.iconId = in.readInt();
        this.title = in.readString();
        this.shouldShowPaymentMethod = in.readByte() != 0;
        this.exitActionPrimary = (ExitAction)in.readParcelable(ExitAction.class.getClassLoader());
        this.exitActionSecondary = (ExitAction)in.readParcelable(ExitAction.class.getClassLoader());
        this.decorator = Decorator.fromName(in.readString());
        this.help = in.readString();
        this.statementDescription = in.readString();
        this.receiptId = in.readString();
        this.imageUrl = in.readString();
        this.topFragment = (ExternalFragment)in.readParcelable(ExternalFragment.class.getClassLoader());
        this.bottomFragment = (ExternalFragment)in.readParcelable(ExternalFragment.class.getClassLoader());
        this.paymentStatus = in.readString();
        this.paymentStatusDetail = in.readString();
        this.subtitle = ParcelableUtil.getOptionalString(in);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.iconId);
        dest.writeString(this.title);
        dest.writeByte((byte)(this.shouldShowPaymentMethod ? 1 : 0));
        dest.writeParcelable((Parcelable)this.exitActionPrimary, flags);
        dest.writeParcelable((Parcelable)this.exitActionSecondary, flags);
        dest.writeString(this.decorator.name);
        dest.writeString(this.help);
        dest.writeString(this.statementDescription);
        dest.writeString(this.receiptId);
        dest.writeString(this.imageUrl);
        dest.writeParcelable((Parcelable)this.topFragment, 0);
        dest.writeParcelable((Parcelable)this.bottomFragment, 0);
        dest.writeString(this.paymentStatus);
        dest.writeString(this.paymentStatusDetail);
        ParcelableUtil.writeOptional(dest, this.subtitle);
    }

    public boolean hasReceipt() {
        return this.receiptId != null;
    }

    public boolean hasTopFragment() {
        return this.getTopFragment() != null;
    }

    public boolean hasBottomFragment() {
        return this.getBottomFragment() != null;
    }

    @NonNull
    public Decorator getDecorator() {
        return this.decorator;
    }

    public int getIcon() {
        return this.iconId;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public boolean hasHelp() {
        return TextUtil.isNotEmpty(this.help);
    }

    @Nullable
    public ExitAction getSecondaryAction() {
        return this.exitActionSecondary;
    }

    @Nullable
    public ExitAction getPrimaryAction() {
        return this.exitActionPrimary;
    }

    @Nullable
    public String getHelp() {
        return this.help;
    }

    public boolean shouldShowPaymentMethod() {
        return this.shouldShowPaymentMethod;
    }

    @Override
    @Nullable
    public Long getId() {
        return Long.getLong(this.receiptId);
    }

    @Override
    @Nullable
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Nullable
    public String getReceipt() {
        return this.receiptId;
    }

    @Nullable
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Nullable
    public ExternalFragment getTopFragment() {
        return this.topFragment;
    }

    @Nullable
    public ExternalFragment getBottomFragment() {
        return this.bottomFragment;
    }

    @Override
    @NonNull
    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    @Override
    @NonNull
    public String getPaymentStatusDetail() {
        return this.paymentStatusDetail;
    }

    @Nullable
    public String getSubtitle() {
        return this.subtitle;
    }

    public static final class Builder {
        @NonNull
        final Decorator decorator;
        @DrawableRes
        final int iconId;
        @NonNull
        final String title;
        @NonNull
        final String paymentStatus;
        @NonNull
        final String paymentStatusDetail;
        @Nullable
        String imageUrl;
        boolean shouldShowPaymentMethod;
        @Nullable
        String statementDescription;
        @Nullable
        ExitAction buttonPrimary;
        @Nullable
        ExitAction buttonSecondary;
        @Nullable
        String help;
        @Nullable
        String receiptId;
        @Nullable
        String subtitle;
        ExternalFragment topFragment;
        ExternalFragment bottomFragment;

        public Builder(@NonNull Decorator decorator, @NonNull String paymentStatus, @NonNull String paymentStatusDetail, @DrawableRes int iconId, @NonNull String title) {
            this.title = title;
            this.decorator = decorator;
            this.iconId = iconId;
            this.paymentStatus = paymentStatus;
            this.paymentStatusDetail = paymentStatusDetail;
            this.shouldShowPaymentMethod = false;
            this.buttonPrimary = null;
            this.buttonSecondary = null;
            this.help = null;
            this.receiptId = null;
            this.imageUrl = null;
        }

        public Builder(@NonNull Decorator decorator, @NonNull String paymentStatus, @NonNull String paymentStatusDetail, @NonNull String imageUrl, @NonNull String title) {
            this(decorator, paymentStatus, paymentStatusDetail, 0, title);
            this.imageUrl = imageUrl;
        }

        public BusinessPayment build() {
            if (this.buttonPrimary == null && this.buttonSecondary == null) {
                throw new IllegalStateException("At least one button should be provided for BusinessPayment");
            }
            return new BusinessPayment(this);
        }

        public Builder setPrimaryButton(@Nullable ExitAction exitAction) {
            this.buttonPrimary = exitAction;
            return this;
        }

        public Builder setSecondaryButton(@Nullable ExitAction exitAction) {
            this.buttonSecondary = exitAction;
            return this;
        }

        public Builder setHelp(@Nullable String help) {
            this.help = help;
            return this;
        }

        public Builder setPaymentMethodVisibility(boolean visible) {
            this.shouldShowPaymentMethod = visible;
            return this;
        }

        public Builder setStatementDescription(String statementDescription) {
            this.statementDescription = statementDescription;
            return this;
        }

        public Builder setReceiptId(String receiptId) {
            this.receiptId = receiptId;
            return this;
        }

        public Builder setTopFragment(@NonNull Class<? extends Fragment> zClass, @Nullable Bundle args) {
            this.topFragment = new ExternalFragment(zClass, args);
            return this;
        }

        public Builder setBottomFragment(@NonNull Class<? extends Fragment> zClass, @Nullable Bundle args) {
            this.bottomFragment = new ExternalFragment(zClass, args);
            return this;
        }

        public Builder setSubtitle(@Nullable String subtitle) {
            this.subtitle = subtitle;
            return this;
        }
    }

    public static enum Decorator {
        APPROVED("APPROVED"),
        REJECTED("REJECTED"),
        PENDING("PENDING");

        public final String name;

        private Decorator(String name) {
            this.name = name;
        }

        public static Decorator fromName(String text) {
            for (Decorator s : Decorator.values()) {
                if (!s.name.equalsIgnoreCase(text)) continue;
                return s;
            }
            throw new IllegalStateException("Invalid decorator");
        }
    }
}

