/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.services.adapters;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.gson.reflect.TypeToken;
import com.mercadopago.android.px.model.Payment;
import com.mercadopago.android.px.model.Token;
import com.mercadopago.android.px.services.adapters.MPCall;
import com.mercadopago.android.px.services.callbacks.Callback;
import com.mercadopago.android.px.services.util.ApiUtil;
import com.mercadopago.android.px.tracking.tracker.MPTracker;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

public class ErrorHandlingCallAdapter {
    private static void executeOnMainThread(@NonNull Runnable r) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(r);
    }

    static class MPCallAdapter<T>
    implements MPCall<T> {
        private final Call<T> call;

        MPCallAdapter(Call<T> call) {
            this.call = call;
        }

        @Override
        public void enqueue(final Callback<T> callback) {
            this.call.enqueue(new retrofit2.Callback<T>(){

                public void onResponse(@NonNull Call<T> call, @NonNull Response<T> response) {
                    final Response r = response;
                    ErrorHandlingCallAdapter.executeOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            int code = r.code();
                            if (code >= 200 && code < 300) {
                                Object body = r.body();
                                if (body instanceof Payment) {
                                    Payment mPayment = (Payment)body;
                                    if (!mPayment.isCardPaymentType(mPayment.getPaymentTypeId()).booleanValue()) {
                                        MPTracker.getInstance().trackPayment(new Long(mPayment.getId()), mPayment.getPaymentTypeId());
                                    }
                                } else if (body instanceof Token) {
                                    Token mToken = (Token)body;
                                    MPTracker.getInstance().trackToken(mToken.getId());
                                }
                                callback.success(body);
                            } else {
                                callback.failure(ApiUtil.getApiException(r));
                            }
                        }
                    });
                }

                public void onFailure(@NonNull Call<T> call, @NonNull Throwable t) {
                    final Throwable th = t;
                    if (++callback.attempts == 3 || th instanceof SocketTimeoutException) {
                        ErrorHandlingCallAdapter.executeOnMainThread(new Runnable(){

                            @Override
                            public void run() {
                                callback.failure(ApiUtil.getApiException(th));
                            }
                        });
                    } else {
                        call.clone().enqueue((retrofit2.Callback)this);
                    }
                }
            });
        }

        @Override
        public void execute(Callback<T> callback) {
            try {
                Response execute = this.call.execute();
                if (execute.isSuccessful()) {
                    Object body = execute.body();
                    callback.success(body);
                } else {
                    callback.failure(ApiUtil.getApiException(execute));
                }
            }
            catch (IOException e) {
                callback.failure(ApiUtil.getApiException(e));
            }
        }
    }

    public static class ErrorHandlingCallAdapterFactory
    extends CallAdapter.Factory {
        public CallAdapter<MPCall<?>, MPCallAdapter> get(@NonNull Type returnType, @NonNull Annotation[] annotations, @NonNull Retrofit retrofit) {
            TypeToken token = TypeToken.get((Type)returnType);
            if (token.getRawType() != MPCall.class) {
                return null;
            }
            if (!(returnType instanceof ParameterizedType)) {
                throw new IllegalStateException("MPCall must have generic type (e.g., MPCall<ResponseBody>)");
            }
            final Type responseType = ((ParameterizedType)returnType).getActualTypeArguments()[0];
            return new CallAdapter<MPCall<?>, MPCallAdapter>(){

                public Type responseType() {
                    return responseType;
                }

                public MPCallAdapter adapt(@NonNull Call<MPCall<?>> call) {
                    return new MPCallAdapter(call);
                }
            };
        }
    }
}

