/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.preferences;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ServicePreference
implements Serializable {
    @SerializedName(value="default_base_url")
    private final String defaultBaseURL;
    @SerializedName(value="gateway_base_url")
    private final String gatewayBaseURL;
    @SerializedName(value="get_customer_url")
    private final String getCustomerURL;
    @SerializedName(value="create_payment_url")
    private final String createPaymentURL;
    @SerializedName(value="create_checkout_preference_url")
    private final String createCheckoutPreferenceURL;
    @SerializedName(value="get_customer_uri")
    private final String getCustomerURI;
    @SerializedName(value="create_payment_uri")
    private final String createPaymentURI;
    @SerializedName(value="create_checkout_preference_uri")
    private final String createCheckoutPreferenceURI;
    @SerializedName(value="processing_mode")
    private final String processingMode;
    private Map<String, String> getCustomerAdditionalInfo;
    private Map<String, Object> createPaymentAdditionalInfo;
    private Map<String, Object> createCheckoutPreferenceAdditionalInfo;

    private ServicePreference(Builder builder) {
        this.defaultBaseURL = builder.defaultBaseURL;
        this.gatewayBaseURL = builder.gatewayBaseURL;
        this.getCustomerURL = builder.getCustomerURL;
        this.createPaymentURL = builder.createPaymentURL;
        this.createCheckoutPreferenceURL = builder.createCheckoutPreferenceURL;
        this.getCustomerURI = builder.getCustomerURI;
        this.createPaymentURI = builder.createPaymentURI;
        this.createCheckoutPreferenceURI = builder.createCheckoutPreferenceURI;
        this.getCustomerAdditionalInfo = builder.getCustomerAdditionalInfo;
        this.createPaymentAdditionalInfo = builder.createPaymentAdditionalInfo;
        this.createCheckoutPreferenceAdditionalInfo = builder.createCheckoutPreferenceAdditionalInfo;
        this.processingMode = builder.processingMode;
    }

    public String getDefaultBaseURL() {
        return this.defaultBaseURL;
    }

    public String getGatewayBaseURL() {
        return this.gatewayBaseURL;
    }

    public String getGetCustomerURL() {
        return this.getCustomerURL;
    }

    public String getCreatePaymentURL() {
        return this.createPaymentURL;
    }

    public String getCreateCheckoutPreferenceURL() {
        return this.createCheckoutPreferenceURL;
    }

    public String getGetCustomerURI() {
        return this.getCustomerURI;
    }

    public String getCreatePaymentURI() {
        return this.createPaymentURI;
    }

    public String getCreateCheckoutPreferenceURI() {
        return this.createCheckoutPreferenceURI;
    }

    public String getProcessingModeString() {
        return this.processingMode;
    }

    public Map<String, String> getGetCustomerAdditionalInfo() {
        if (this.getCustomerAdditionalInfo == null) {
            this.getCustomerAdditionalInfo = new HashMap<String, String>();
        }
        return this.getCustomerAdditionalInfo;
    }

    public Map<String, Object> getCreatePaymentAdditionalInfo() {
        if (this.createPaymentAdditionalInfo == null) {
            this.createPaymentAdditionalInfo = new HashMap<String, Object>();
        }
        return this.createPaymentAdditionalInfo;
    }

    public Map<String, Object> getCreateCheckoutPreferenceAdditionalInfo() {
        if (this.createCheckoutPreferenceAdditionalInfo == null) {
            this.createCheckoutPreferenceAdditionalInfo = new HashMap<String, Object>();
        }
        return this.createCheckoutPreferenceAdditionalInfo;
    }

    public boolean hasGetCustomerURL() {
        return this.getCustomerURL != null && this.getCustomerURI != null;
    }

    public boolean hasCreatePaymentURL() {
        return this.createPaymentURL != null && this.createPaymentURI != null;
    }

    public boolean hasCreateCheckoutPrefURL() {
        return this.createCheckoutPreferenceURL != null && this.createCheckoutPreferenceURI != null;
    }

    public boolean shouldShowBankDeals() {
        return this.processingMode.equals("aggregator");
    }

    public boolean shouldShowEmailConfirmationCell() {
        return this.processingMode.equals("aggregator");
    }

    public static class Builder {
        private String defaultBaseURL;
        private String gatewayBaseURL;
        private String getCustomerURL;
        private String createPaymentURL;
        private String createCheckoutPreferenceURL;
        private String getCustomerURI;
        private String createPaymentURI;
        private String createCheckoutPreferenceURI;
        private String processingMode;
        private Map<String, String> getCustomerAdditionalInfo;
        private Map<String, Object> createPaymentAdditionalInfo;
        private Map<String, Object> createCheckoutPreferenceAdditionalInfo;

        public Builder setGetCustomerURL(String getCustomerURL, String getCustomerURI) {
            this.getCustomerURL = getCustomerURL;
            this.getCustomerURI = this.getURI(getCustomerURI);
            return this;
        }

        public Builder setGetCustomerURL(String getCustomerURL, String getCustomerURI, Map<String, String> additionalInfo) {
            this.getCustomerURL = getCustomerURL;
            this.getCustomerURI = this.getURI(getCustomerURI);
            this.getCustomerAdditionalInfo = additionalInfo;
            return this;
        }

        public Builder setCreatePaymentURL(String createPaymentURL, String createPaymentURI) {
            this.createPaymentURL = createPaymentURL;
            this.createPaymentURI = this.getURI(createPaymentURI);
            return this;
        }

        public Builder setCreatePaymentURL(String createPaymentURL, String createPaymentURI, Map<String, Object> additionalInfo) {
            this.createPaymentURL = createPaymentURL;
            this.createPaymentURI = this.getURI(createPaymentURI);
            this.createPaymentAdditionalInfo = additionalInfo;
            return this;
        }

        public Builder setCreateCheckoutPreferenceURL(String createCheckoutPreferenceURL, String createCheckoutPreferenceURI) {
            this.createCheckoutPreferenceURL = createCheckoutPreferenceURL;
            this.createCheckoutPreferenceURI = this.getURI(createCheckoutPreferenceURI);
            return this;
        }

        public Builder setCreateCheckoutPreferenceURL(String createCheckoutPreferenceURL, String createCheckoutPreferenceURI, Map<String, Object> additionalInfo) {
            this.createCheckoutPreferenceURL = createCheckoutPreferenceURL;
            this.createCheckoutPreferenceURI = this.getURI(createCheckoutPreferenceURI);
            this.createCheckoutPreferenceAdditionalInfo = additionalInfo;
            return this;
        }

        public Builder setDefaultBaseURL(String defaultBaseURL) {
            this.defaultBaseURL = defaultBaseURL;
            return this;
        }

        public Builder setGatewayURL(String gatewayBaseURL) {
            this.gatewayBaseURL = gatewayBaseURL;
            return this;
        }

        public Builder setAggregatorAsProcessingMode() {
            this.processingMode = "aggregator";
            return this;
        }

        public Builder setGatewayAsProcessingMode() {
            this.processingMode = "gateway";
            return this;
        }

        public Builder setHybridAsProcessingMode() {
            this.processingMode = "gateway,aggregator";
            return this;
        }

        public ServicePreference build() {
            if (this.processingMode == null) {
                this.processingMode = "aggregator";
            }
            return new ServicePreference(this);
        }

        private String getURI(String uri) {
            return uri.startsWith("/") ? uri.substring(1) : uri;
        }
    }
}

