/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.services.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import com.google.gson.Gson;
import com.mercadopago.android.px.model.BankDeal;
import com.mercadopago.android.px.model.CardToken;
import com.mercadopago.android.px.model.Customer;
import com.mercadopago.android.px.model.Discount;
import com.mercadopago.android.px.model.IdentificationType;
import com.mercadopago.android.px.model.Installment;
import com.mercadopago.android.px.model.Instructions;
import com.mercadopago.android.px.model.Issuer;
import com.mercadopago.android.px.model.Payer;
import com.mercadopago.android.px.model.Payment;
import com.mercadopago.android.px.model.PaymentMethod;
import com.mercadopago.android.px.model.PaymentMethodSearch;
import com.mercadopago.android.px.model.SavedCardToken;
import com.mercadopago.android.px.model.SavedESCCardToken;
import com.mercadopago.android.px.model.Site;
import com.mercadopago.android.px.model.Token;
import com.mercadopago.android.px.model.requests.PayerIntent;
import com.mercadopago.android.px.model.requests.SecurityCodeIntent;
import com.mercadopago.android.px.preferences.CheckoutPreference;
import com.mercadopago.android.px.preferences.ServicePreference;
import com.mercadopago.android.px.services.BankDealService;
import com.mercadopago.android.px.services.CheckoutService;
import com.mercadopago.android.px.services.CustomService;
import com.mercadopago.android.px.services.DiscountService;
import com.mercadopago.android.px.services.GatewayService;
import com.mercadopago.android.px.services.IdentificationService;
import com.mercadopago.android.px.services.PaymentService;
import com.mercadopago.android.px.services.adapters.ErrorHandlingCallAdapter;
import com.mercadopago.android.px.services.callbacks.Callback;
import com.mercadopago.android.px.services.controllers.CustomServicesHandler;
import com.mercadopago.android.px.services.core.Settings;
import com.mercadopago.android.px.services.util.HttpClientUtil;
import com.mercadopago.android.px.services.util.JsonUtil;
import com.mercadopago.android.px.services.util.TextUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MercadoPagoServices {
    private static final String MP_API_BASE_URL = "https://api.mercadopago.com";
    public static final int DEFAULT_CONNECT_TIMEOUT = 10;
    public static final int DEFAULT_READ_TIMEOUT = 20;
    public static final int DEFAULT_WRITE_TIMEOUT = 20;
    public static final int DEFAULT_PAYMENT_CONNECT_TIMEOUT = 10;
    public static final int DEFAULT_PAYMENT_READ_TIMEOUT = 20;
    public static final int DEFAULT_PAYMENT_WRITE_TIMEOUT = 20;
    private ServicePreference mServicePreference;
    private final Context mContext;
    private final String mPublicKey;
    private final String mPrivateKey;
    private String mProcessingMode;

    private MercadoPagoServices(Builder builder) {
        this.mContext = builder.mContext;
        this.mPublicKey = builder.mPublicKey;
        this.mPrivateKey = builder.mPrivateKey;
        this.mServicePreference = CustomServicesHandler.getInstance().getServicePreference();
        this.mProcessingMode = this.mServicePreference != null ? this.mServicePreference.getProcessingModeString() : "aggregator";
    }

    protected MercadoPagoServices(Context mContext, String mPublicKey, String mPrivateKey) {
        this.mContext = mContext;
        this.mPublicKey = mPublicKey;
        this.mPrivateKey = mPrivateKey;
        this.mServicePreference = CustomServicesHandler.getInstance().getServicePreference();
        this.mProcessingMode = this.mServicePreference != null ? this.mServicePreference.getProcessingModeString() : "aggregator";
    }

    public void getCheckoutPreference(String checkoutPreferenceId, Callback<CheckoutPreference> callback) {
        CheckoutService service = (CheckoutService)MercadoPagoServices.getDefaultRetrofit(this.mContext).create(CheckoutService.class);
        service.getPreference(Settings.servicesVersion, checkoutPreferenceId, this.mPublicKey).enqueue(callback);
    }

    public void getInstructions(Long paymentId, String paymentTypeId, Callback<Instructions> callback) {
        CheckoutService service = (CheckoutService)MercadoPagoServices.getDefaultRetrofit(this.mContext).create(CheckoutService.class);
        service.getPaymentResult(Settings.servicesVersion, this.mContext.getResources().getConfiguration().locale.getLanguage(), paymentId, this.mPublicKey, this.mPrivateKey, paymentTypeId, "1.4").enqueue(callback);
    }

    @SuppressLint(value={"unused"})
    public void getPaymentMethodSearch(BigDecimal amount, List<String> excludedPaymentTypes, List<String> excludedPaymentMethods, List<String> cardsWithEsc, List<String> supportedPlugins, Payer payer, Site site, Callback<PaymentMethodSearch> callback) {
        PayerIntent payerIntent = new PayerIntent(payer);
        CheckoutService service = (CheckoutService)MercadoPagoServices.getDefaultRetrofit(this.mContext).create(CheckoutService.class);
        String separator = ",";
        String excludedPaymentTypesAppended = this.getListAsString(excludedPaymentTypes, ",");
        String excludedPaymentMethodsAppended = this.getListAsString(excludedPaymentMethods, ",");
        String cardsWithEscAppended = this.getListAsString(cardsWithEsc, ",");
        String supportedPluginsAppended = this.getListAsString(supportedPlugins, ",");
        service.getPaymentMethodSearch(Settings.servicesVersion, this.mContext.getResources().getConfiguration().locale.getLanguage(), this.mPublicKey, amount, excludedPaymentTypesAppended, excludedPaymentMethodsAppended, payerIntent, site.getId(), "1.6", this.mProcessingMode, cardsWithEscAppended, supportedPluginsAppended).enqueue(callback);
    }

    public void createToken(final SavedCardToken savedCardToken, final Callback<Token> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                savedCardToken.setDevice(MercadoPagoServices.this.mContext);
                GatewayService service = (GatewayService)MercadoPagoServices.this.getGatewayRetrofit().create(GatewayService.class);
                service.getToken(MercadoPagoServices.this.mPublicKey, MercadoPagoServices.this.mPrivateKey, savedCardToken).enqueue(callback);
            }
        }).start();
    }

    public void createToken(final CardToken cardToken, final Callback<Token> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                cardToken.setDevice(MercadoPagoServices.this.mContext);
                GatewayService service = (GatewayService)MercadoPagoServices.this.getGatewayRetrofit().create(GatewayService.class);
                service.getToken(MercadoPagoServices.this.mPublicKey, MercadoPagoServices.this.mPrivateKey, cardToken).enqueue(callback);
            }
        }).start();
    }

    public void createToken(final SavedESCCardToken savedESCCardToken, final Callback<Token> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                savedESCCardToken.setDevice(MercadoPagoServices.this.mContext);
                GatewayService service = (GatewayService)MercadoPagoServices.this.getGatewayRetrofit().create(GatewayService.class);
                service.getToken(MercadoPagoServices.this.mPublicKey, MercadoPagoServices.this.mPrivateKey, savedESCCardToken).enqueue(callback);
            }
        }).start();
    }

    public void cloneToken(String tokenId, Callback<Token> callback) {
        GatewayService service = (GatewayService)this.getGatewayRetrofit().create(GatewayService.class);
        service.getToken(tokenId, this.mPublicKey, this.mPrivateKey).enqueue(callback);
    }

    public void putSecurityCode(String tokenId, SecurityCodeIntent securityCodeIntent, Callback<Token> callback) {
        GatewayService service = (GatewayService)this.getGatewayRetrofit().create(GatewayService.class);
        service.getToken(tokenId, this.mPublicKey, this.mPrivateKey, securityCodeIntent).enqueue(callback);
    }

    public void getBankDeals(Callback<List<BankDeal>> callback) {
        BankDealService service = (BankDealService)MercadoPagoServices.getDefaultRetrofit(this.mContext).create(BankDealService.class);
        service.getBankDeals(this.mPublicKey, this.mPrivateKey, this.mContext.getResources().getConfiguration().locale.toString()).enqueue(callback);
    }

    public void getIdentificationTypes(Callback<List<IdentificationType>> callback) {
        IdentificationService service = (IdentificationService)MercadoPagoServices.getDefaultRetrofit(this.mContext).create(IdentificationService.class);
        service.getIdentificationTypes(this.mPublicKey, this.mPrivateKey).enqueue(callback);
    }

    public void getInstallments(String bin, BigDecimal amount, Long issuerId, String paymentMethodId, Callback<List<Installment>> callback) {
        PaymentService service = (PaymentService)MercadoPagoServices.getDefaultRetrofit(this.mContext).create(PaymentService.class);
        service.getInstallments(Settings.servicesVersion, this.mPublicKey, this.mPrivateKey, bin, amount, issuerId, paymentMethodId, this.mContext.getResources().getConfiguration().locale.toString(), this.mProcessingMode).enqueue(callback);
    }

    public void getIssuers(String paymentMethodId, String bin, Callback<List<Issuer>> callback) {
        PaymentService service = (PaymentService)MercadoPagoServices.getDefaultRetrofit(this.mContext).create(PaymentService.class);
        service.getIssuers(Settings.servicesVersion, this.mPublicKey, this.mPrivateKey, paymentMethodId, bin, this.mProcessingMode).enqueue(callback);
    }

    public void getPaymentMethods(Callback<List<PaymentMethod>> callback) {
        PaymentService service = (PaymentService)MercadoPagoServices.getDefaultRetrofit(this.mContext).create(PaymentService.class);
        service.getPaymentMethods(this.mPublicKey, this.mPrivateKey).enqueue(callback);
    }

    public void getDirectDiscount(String amount, String payerEmail, Callback<Discount> callback) {
        DiscountService service = (DiscountService)MercadoPagoServices.getDefaultRetrofit(this.mContext).create(DiscountService.class);
        service.getDiscount(this.mPublicKey, amount, payerEmail).enqueue(callback);
    }

    public void getCodeDiscount(String amount, String payerEmail, String couponCode, Callback<Discount> callback) {
        DiscountService service = (DiscountService)MercadoPagoServices.getDefaultRetrofit(this.mContext).create(DiscountService.class);
        service.getDiscount(this.mPublicKey, amount, payerEmail, couponCode).enqueue(callback);
    }

    public void getCustomer(String url, String uri, Callback<Customer> callback) {
        CustomService customService = this.getCustomService(url);
        customService.getCustomer(uri, null).enqueue(callback);
    }

    public void getCustomer(String url, String uri, @NonNull Map<String, String> additionalInfo, Callback<Customer> callback) {
        CustomService customService = this.getCustomService(url);
        customService.getCustomer(uri, additionalInfo).enqueue(callback);
    }

    public void createPayment(String baseUrl, String uri, Map<String, Object> paymentData, @NonNull Map<String, String> query, Callback<Payment> callback) {
        CustomService customService = this.getCustomService(baseUrl, 10, 20, 20);
        customService.createPayment(Settings.servicesVersion, MercadoPagoServices.ripFirstSlash(uri), paymentData, query).enqueue(callback);
    }

    public void createPayment(String transactionId, String baseUrl, String uri, Map<String, Object> paymentData, @NonNull Map<String, String> query, Callback<Payment> callback) {
        CustomService customService = this.getCustomService(baseUrl, 10, 20, 20);
        customService.createPayment(transactionId, MercadoPagoServices.ripFirstSlash(uri), paymentData, query).enqueue(callback);
    }

    public static Retrofit getDefaultRetrofit(Context context) {
        return MercadoPagoServices.getDefaultRetrofit(context, 10, 20, 20);
    }

    private static Retrofit getDefaultRetrofit(Context context, int connectTimeout, int readTimeout, int writeTimeout) {
        return MercadoPagoServices.getRetrofit(context, MP_API_BASE_URL, connectTimeout, readTimeout, writeTimeout);
    }

    private Retrofit getGatewayRetrofit() {
        return this.getGatewayRetrofit(10, 20, 20);
    }

    private Retrofit getGatewayRetrofit(int connectTimeout, int readTimeout, int writeTimeout) {
        String baseUrl = this.mServicePreference != null && !TextUtil.isEmpty(this.mServicePreference.getGatewayBaseURL()) ? this.mServicePreference.getGatewayBaseURL() : (this.mServicePreference != null && !TextUtil.isEmpty(this.mServicePreference.getDefaultBaseURL()) ? this.mServicePreference.getDefaultBaseURL() : MP_API_BASE_URL);
        return MercadoPagoServices.getRetrofit(this.mContext, baseUrl, connectTimeout, readTimeout, writeTimeout);
    }

    private CustomService getCustomService(String url) {
        return this.getCustomService(url, 10, 20, 20);
    }

    private CustomService getCustomService(String baseUrl, int connectTimeout, int readTimeout, int writeTimeout) {
        Retrofit retrofit = MercadoPagoServices.getRetrofit(this.mContext, baseUrl, connectTimeout, readTimeout, writeTimeout);
        return (CustomService)retrofit.create(CustomService.class);
    }

    private static String ripFirstSlash(String uri) {
        return uri.startsWith("/") ? uri.substring(1) : uri;
    }

    private static Retrofit getRetrofit(Context mContext, String baseUrl, int connectTimeout, int readTimeout, int writeTimeout) {
        return new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)JsonUtil.getInstance().getGson())).client(HttpClientUtil.getClient(mContext, connectTimeout, readTimeout, writeTimeout)).addCallAdapterFactory((CallAdapter.Factory)new ErrorHandlingCallAdapter.ErrorHandlingCallAdapterFactory()).build();
    }

    private String getListAsString(List<String> list, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null) {
            for (String typeId : list) {
                stringBuilder.append(typeId);
                if (typeId.equals(list.get(list.size() - 1))) continue;
                stringBuilder.append(separator);
            }
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private Context mContext = null;
        private String mPublicKey = null;
        public String mPrivateKey;
        public ServicePreference mServicePreference;

        public Builder setContext(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("context is null");
            }
            this.mContext = context;
            return this;
        }

        public Builder setPrivateKey(String key) {
            this.mPrivateKey = key;
            return this;
        }

        public Builder setPublicKey(String key) {
            this.mPublicKey = key;
            return this;
        }

        public Builder setServicePreference(ServicePreference servicePreference) {
            this.mServicePreference = servicePreference;
            return this;
        }

        @Deprecated
        public Builder setBetaEnvironment(Boolean betaEnvironment) {
            throw new IllegalStateException("deprecated");
        }

        public MercadoPagoServices build() {
            if (this.mContext == null) {
                throw new IllegalStateException("context is null");
            }
            if (TextUtil.isEmpty(this.mPublicKey) && TextUtil.isEmpty(this.mPrivateKey)) {
                throw new IllegalStateException("key is null");
            }
            return new MercadoPagoServices(this);
        }
    }
}

