/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.support.annotation.NonNull;
import android.support.annotation.Size;
import com.mercadopago.android.px.services.util.CurrenciesUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

public class Item
implements Serializable {
    private String categoryId;
    private String currencyId;
    private String description;
    private String id;
    private String pictureUrl;
    private Integer quantity;
    private String title;
    private BigDecimal unitPrice;

    public Item(String description, Integer quantity, BigDecimal unitPrice) {
        this.description = description;
        this.quantity = quantity;
        this.unitPrice = unitPrice;
    }

    public Item(String description, Integer quantity, BigDecimal unitPrice, String pictureUrl) {
        this.description = description;
        this.quantity = quantity;
        this.unitPrice = unitPrice;
        this.pictureUrl = pictureUrl;
    }

    public Item(String description, BigDecimal amount) {
        this.description = description;
        this.quantity = 1;
        this.unitPrice = amount;
    }

    public Item(String description, BigDecimal amount, String pictureUrl) {
        this.description = description;
        this.quantity = 1;
        this.unitPrice = amount;
        this.pictureUrl = pictureUrl;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public boolean hasCardinality() {
        return this.quantity != null && this.quantity > 1;
    }

    private boolean isValid() {
        return BigDecimal.ZERO.compareTo(this.getUnitPrice()) < 0 && this.getQuantity() != null && this.getQuantity() > 0 && CurrenciesUtil.isValidCurrency(this.getCurrencyId()) && this.getId() != null;
    }

    public static BigDecimal getItemTotalAmount(@NonNull Item item) {
        return item.getUnitPrice().multiply(new BigDecimal(item.getQuantity()));
    }

    private static boolean haveAllSameCurrency(@Size(min=1L) @NonNull List<Item> items) {
        boolean areAllTheSameCurrency = true;
        String currencyId = items.get(0).getCurrencyId();
        for (int i = 1; i < items.size(); ++i) {
            areAllTheSameCurrency = areAllTheSameCurrency && currencyId.equals(items.get(i).getCurrencyId());
        }
        return areAllTheSameCurrency;
    }

    private static boolean eachIsValid(@NonNull List<Item> items) {
        boolean areAllValid = true;
        for (Item item : items) {
            areAllValid = areAllValid && item.isValid();
        }
        return areAllValid;
    }

    public static boolean validItems(@NonNull List<Item> items) {
        return !items.isEmpty() && Item.eachIsValid(items) && Item.haveAllSameCurrency(items);
    }

    public static BigDecimal getTotalAmountWith(@NonNull List<Item> items) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Item item : items) {
            totalAmount = totalAmount.add(Item.getItemTotalAmount(item));
        }
        return totalAmount;
    }

    public static String getItemsTitle(@NonNull @Size(min=1L) List<Item> items, String multipleDefault) {
        return items.size() > 1 ? multipleDefault : items.get(0).getTitle();
    }
}

