/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.picassodiskcache;

import android.content.Context;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.StatFs;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.NetworkPolicy;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/mercadolibre/android/picassodiskcache/PicassoDiskDownloader;", "Lcom/squareup/picasso/Downloader;", "cacheDir", "Ljava/io/File;", "maxSize", "", "(Ljava/io/File;J)V", "(Ljava/io/File;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "builder", "Lokhttp3/OkHttpClient$Builder;", "(Lokhttp3/OkHttpClient$Builder;)V", "cache", "Lokhttp3/Cache;", "client", "Lokhttp3/OkHttpClient;", "load", "Lcom/squareup/picasso/Downloader$Response;", "uri", "Landroid/net/Uri;", "networkPolicy", "", "shutdown", "", "Companion", "picasso-disk-cache_release"})
public final class PicassoDiskDownloader
implements Downloader {
    private final OkHttpClient client;
    private final Cache cache;
    private static final String PICASSO_CACHE = "picasso/cache";
    private static final long MAX_DISK_CACHE_SIZE = 0xA00000L;
    private static final long MIN_DISK_CACHE_SIZE = 0x500000L;
    private static final int THREAD_STATS_TAG;
    public static final Companion Companion;

    @Nullable
    public Downloader.Response load(@NotNull Uri uri, int networkPolicy) throws IOException {
        Downloader.Response response;
        CacheControl it;
        boolean bl;
        boolean bl2;
        CacheControl cacheControl;
        CacheControl.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        CacheControl cacheControl2 = null;
        if (networkPolicy != 0) {
            CacheControl cacheControl3;
            if (NetworkPolicy.isOfflineOnly((int)networkPolicy)) {
                cacheControl3 = CacheControl.FORCE_CACHE;
            } else {
                builder = new CacheControl.Builder();
                if (!NetworkPolicy.shouldReadFromDiskCache((int)networkPolicy)) {
                    builder.noCache();
                }
                if (!NetworkPolicy.shouldWriteToDiskCache((int)networkPolicy)) {
                    builder.noStore();
                }
                cacheControl3 = builder.build();
            }
            cacheControl2 = cacheControl3;
        }
        builder = new Request.Builder().url(uri.toString());
        CacheControl cacheControl4 = cacheControl2;
        if (cacheControl4 != null) {
            cacheControl = cacheControl4;
            bl2 = false;
            bl = false;
            it = cacheControl;
            boolean bl3 = false;
            builder.cacheControl(it);
        }
        TrafficStats.setThreadStatsTag((int)THREAD_STATS_TAG);
        Response response2 = this.client.newCall(builder.build()).execute();
        if (response2 != null) {
            cacheControl = response2;
            bl2 = false;
            bl = false;
            it = cacheControl;
            boolean bl4 = false;
            ResponseBody responseBody = it.body();
            if (responseBody != null) {
                ResponseBody responseBody2 = responseBody;
                boolean bl5 = false;
                boolean bl6 = false;
                ResponseBody $this$run = responseBody2;
                boolean bl7 = false;
                response = new Downloader.Response($this$run.byteStream(), it.cacheResponse() != null, $this$run.contentLength());
            } else {
                response = null;
            }
        } else {
            response = null;
        }
        return response;
    }

    public void shutdown() {
        block2: {
            Cache cache = this.cache;
            if (cache == null) break block2;
            Cache cache2 = cache;
            boolean bl = false;
            boolean bl2 = false;
            Cache $this$apply = cache2;
            boolean bl3 = false;
            try {
                $this$apply.close();
            }
            catch (IOException iOException) {
            }
        }
    }

    public PicassoDiskDownloader(@NotNull OkHttpClient.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.addNetworkInterceptor((Interceptor)1.INSTANCE);
        OkHttpClient okHttpClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"builder.build()");
        this.client = okHttpClient;
        this.cache = this.client.cache();
    }

    public PicassoDiskDownloader(@NotNull File cacheDir, long maxSize) {
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cache(new Cache(cacheDir, maxSize));
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"OkHttpClient.Builder().c\u2026e\n            )\n        )");
        this(builder);
    }

    public PicassoDiskDownloader(@NotNull File cacheDir) {
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this(cacheDir, PicassoDiskDownloader.Companion.calculateDiskCacheSize(cacheDir));
    }

    public PicassoDiskDownloader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(PicassoDiskDownloader.Companion.createDefaultCacheDir(context));
    }

    static {
        Companion = new Companion(null);
        THREAD_STATS_TAG = new Random().hashCode();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mercadolibre/android/picassodiskcache/PicassoDiskDownloader$Companion;", "", "()V", "MAX_DISK_CACHE_SIZE", "", "MIN_DISK_CACHE_SIZE", "PICASSO_CACHE", "", "THREAD_STATS_TAG", "", "calculateDiskCacheSize", "dir", "Ljava/io/File;", "createDefaultCacheDir", "context", "Landroid/content/Context;", "picasso-disk-cache_release"})
    public static final class Companion {
        private final long calculateDiskCacheSize(File dir) {
            long size = 0x500000L;
            try {
                StatFs statFs = new StatFs(dir.getAbsolutePath());
                long available = statFs.getBlockCountLong() * statFs.getBlockSizeLong();
                size = available / (long)50;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            long l = 0xA00000L;
            boolean bl = false;
            l = Math.min(size, l);
            long l2 = 0x500000L;
            boolean bl2 = false;
            return Math.max(l, l2);
        }

        private final File createDefaultCacheDir(Context context) {
            File cache;
            block0: {
                File file = cache = new File(context.getCacheDir(), PicassoDiskDownloader.PICASSO_CACHE);
                boolean bl = false;
                boolean bl2 = false;
                File it = file;
                boolean bl3 = false;
                File file2 = !it.exists() ? file : null;
                if (file2 == null) break block0;
                file2.mkdirs();
            }
            return cache;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

