/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.cardform.presentation.ui;

import com.mercadolibre.android.cardform.presentation.model.Identification;
import java.util.InputMismatchException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/mercadolibre/android/cardform/presentation/ui/IdentificationUtils;", "", "()V", "CNPJ", "", "CNPJ_ALGORITHM_EXPECTED_LENGTH", "", "CNPJ_VALID_NUMBERS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CPF", "CPF_ALGORITHM_CHECK_DIGITS_INDEX", "CPF_ALGORITHM_EXPECTED_LENGTH", "CPF_ALGORITHM_LAST_INDEX", "CPF_VALID_NUMBERS_PATTERN", "isBrazilianID", "", "type", "isCnpj", "isCpf", "validate", "number", "identification", "Lcom/mercadolibre/android/cardform/presentation/model/Identification;", "validateCnpj", "cnpj", "", "validateCpf", "cpf", "validateIdentificationNumberLength", "cardform_release"})
public final class IdentificationUtils {
    private static final String CPF = "CPF";
    private static final String CNPJ = "CNPJ";
    private static final int CPF_ALGORITHM_EXPECTED_LENGTH = 11;
    private static final int CPF_ALGORITHM_LAST_INDEX = 10;
    private static final int CPF_ALGORITHM_CHECK_DIGITS_INDEX = 9;
    private static final int CNPJ_ALGORITHM_EXPECTED_LENGTH = 14;
    private static final Pattern CPF_VALID_NUMBERS_PATTERN;
    private static final Pattern CNPJ_VALID_NUMBERS_PATTERN;
    public static final IdentificationUtils INSTANCE;

    public final boolean validate(@NotNull String number, @NotNull Identification identification) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        Intrinsics.checkParameterIsNotNull((Object)identification, (String)"identification");
        boolean isValid = true;
        if (!this.validateIdentificationNumberLength(number, identification)) {
            return false;
        }
        if (this.isCpf(identification.getId())) {
            isValid = this.validateCpf(number);
        } else if (this.isCnpj(identification.getId())) {
            isValid = this.validateCnpj(number);
        }
        return isValid;
    }

    public final boolean isBrazilianID(@NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.isCpf(type) || this.isCnpj(type);
    }

    public final boolean isCnpj(@NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        CharSequence charSequence = type;
        boolean bl = false;
        return charSequence.length() > 0 && Intrinsics.areEqual((Object)type, (Object)CNPJ);
    }

    public final boolean isCpf(@NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        CharSequence charSequence = type;
        boolean bl = false;
        return charSequence.length() > 0 && Intrinsics.areEqual((Object)type, (Object)CPF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateIdentificationNumberLength(String number, Identification identification) {
        CharSequence charSequence = number;
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        charSequence = identification.getId();
        bl = false;
        if (charSequence.length() <= 0) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        int len = number.length();
        int min = identification.getMinLength();
        int n = len;
        if (min > n) return false;
        int max = identification.getMaxLength();
        if (max < n) return false;
        return true;
    }

    private final boolean validateCpf(CharSequence cpf) {
        if (cpf.length() != 11) {
            return true;
        }
        if (CPF_VALID_NUMBERS_PATTERN.matcher(cpf).matches()) {
            boolean bl;
            int i;
            int[] numbers = new int[11];
            int n = 0;
            int n2 = 11;
            while (n < n2) {
                numbers[i] = Character.getNumericValue(cpf.charAt(i));
                ++i;
            }
            i = 0;
            int sum = 0;
            int factor = 100;
            for (i = 0; i < 9; ++i) {
                sum += numbers[i] * factor;
                factor -= 10;
            }
            int leftover = sum % 11;
            int n3 = leftover = leftover == 10 ? 0 : leftover;
            if (leftover == numbers[9]) {
                sum = 0;
                factor = 110;
                for (i = 0; i < 10; ++i) {
                    sum += numbers[i] * factor;
                    factor -= 10;
                }
                leftover = sum % 11;
                int n4 = leftover = leftover == 10 ? 0 : leftover;
                bl = leftover == numbers[10];
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    private final boolean validateCnpj(CharSequence cnpj) {
        if (cnpj.length() != 14) {
            return true;
        }
        if (CNPJ_VALID_NUMBERS_PATTERN.matcher(cnpj).matches()) {
            char cnpj_first_check_digit = '\u0000';
            char cnpj_second_check_digit = '\u0000';
            int sum = 0;
            int i = 0;
            int r = 0;
            int num = 0;
            int weight = 0;
            try {
                sum = 0;
                weight = 2;
                for (i = 11; i >= 0; --i) {
                    num = cnpj.charAt(i) - 48;
                    sum += num * weight;
                    if (++weight != 10) continue;
                    weight = 2;
                }
                r = sum % 11;
                cnpj_first_check_digit = r == 0 || r == 1 ? (char)'0' : (char)(11 - r + 48);
                sum = 0;
                weight = 2;
                for (i = 12; i >= 0; --i) {
                    num = cnpj.charAt(i) - 48;
                    sum += num * weight;
                    if (++weight != 10) continue;
                    weight = 2;
                }
                r = sum % 11;
                cnpj_second_check_digit = r == 0 || r == 1 ? (char)'0' : (char)(11 - r + 48);
                return cnpj_first_check_digit == cnpj.charAt(12) && cnpj_second_check_digit == cnpj.charAt(13);
            }
            catch (InputMismatchException e) {
                return false;
            }
        }
        return false;
    }

    private IdentificationUtils() {
    }

    static {
        IdentificationUtils identificationUtils;
        INSTANCE = identificationUtils = new IdentificationUtils();
        CPF_VALID_NUMBERS_PATTERN = Pattern.compile("(?=^((?!((([0]{11})|([1]{11})|([2]{11})|([3]{11})|([4]{11})|([5]{11})|([6]{11})|([7]{11})|([8]{11})|([9]{11})))).)*$)([0-9]{11})");
        CNPJ_VALID_NUMBERS_PATTERN = Pattern.compile("(?=^((?!((([0]{14})|([1]{14})|([2]{14})|([3]{14})|([4]{14})|([5]{14})|([6]{14})|([7]{14})|([8]{14})|([9]{14})))).)*$)([0-9]{14})");
    }
}

