/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.cardform.presentation.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import com.mercadolibre.android.andesui.snackbar.AndesSnackbar;
import com.mercadolibre.android.andesui.snackbar.action.AndesSnackbarAction;
import com.mercadolibre.android.andesui.snackbar.duration.AndesSnackbarDuration;
import com.mercadolibre.android.andesui.snackbar.type.AndesSnackbarType;
import com.mercadolibre.android.cardform.R;
import com.mercadolibre.android.cardform.network.exceptions.CardFormException;
import com.mercadolibre.android.cardform.presentation.extensions.ViewExtensionsKt;
import com.mercadolibre.android.cardform.presentation.model.UiError;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/mercadolibre/android/cardform/presentation/ui/ErrorUtil;", "", "()V", "createError", "Lcom/mercadolibre/android/cardform/presentation/model/UiError;", "e", "", "resolveError", "", "rootView", "Landroid/view/View;", "uiError", "action", "Landroid/view/View$OnClickListener;", "cardform_release"})
public final class ErrorUtil {
    public static final ErrorUtil INSTANCE;

    @NotNull
    public final UiError createError(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Throwable throwable = e;
        return throwable instanceof SocketTimeoutException ? (UiError)new UiError.TimeOut(R.string.cf_generic_error) : (throwable instanceof UnknownHostException ? (UiError)new UiError.ConnectionError(R.string.cf_without_connection) : (throwable instanceof IOException ? (UiError)new UiError.UnknownError(R.string.cf_generic_error) : (throwable instanceof CardFormException ? (UiError)new UiError.BusinessError(((CardFormException)e).getMessage()) : (UiError)new UiError.UnknownError(R.string.cf_generic_error))));
    }

    public static /* synthetic */ UiError createError$default(ErrorUtil errorUtil, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            throwable = new UnknownError();
        }
        return errorUtil.createError(throwable);
    }

    @SuppressLint(value={"Range"})
    public final void resolveError(@NotNull View rootView, @NotNull UiError uiError, @Nullable View.OnClickListener action) {
        Intrinsics.checkParameterIsNotNull((Object)rootView, (String)"rootView");
        Intrinsics.checkParameterIsNotNull((Object)uiError, (String)"uiError");
        String message = uiError.getMessageResource() != 0 ? ViewExtensionsKt.getStringOrEmpty(rootView, uiError.getMessageResource()) : uiError.getMessage();
        Context context = rootView.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"rootView.context");
        AndesSnackbar andesSnackbar = new AndesSnackbar(context, rootView, AndesSnackbarType.ERROR, message, AndesSnackbarDuration.LONG);
        boolean bl = false;
        boolean bl2 = false;
        AndesSnackbar $this$apply = andesSnackbar;
        boolean bl3 = false;
        if (action != null) {
            new AndesSnackbarAction(String.valueOf(R.string.cf_retry), action);
        }
        andesSnackbar.show();
    }

    public static /* synthetic */ void resolveError$default(ErrorUtil errorUtil, View view, UiError uiError, View.OnClickListener onClickListener, int n, Object object) {
        if ((n & 4) != 0) {
            onClickListener = null;
        }
        errorUtil.resolveError(view, uiError, onClickListener);
    }

    private ErrorUtil() {
    }

    static {
        ErrorUtil errorUtil;
        INSTANCE = errorUtil = new ErrorUtil();
    }
}

