/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.cardform.presentation.ui;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import com.mercadolibre.android.cardform.CardForm;
import com.mercadolibre.android.cardform.R;
import com.mercadolibre.android.cardform.di.CallbackComponentExtKt;
import com.mercadolibre.android.cardform.di.Dependencies;
import com.mercadolibre.android.cardform.di.module.ViewModelModule;
import com.mercadolibre.android.cardform.internal.CardFormWeb;
import com.mercadolibre.android.cardform.presentation.extensions.LiveDataExtensionsKt;
import com.mercadolibre.android.cardform.presentation.extensions.ViewExtensionsKt;
import com.mercadolibre.android.cardform.presentation.model.ScreenState;
import com.mercadolibre.android.cardform.presentation.ui.CardFormWebActivity$setUpViewModel$;
import com.mercadolibre.android.cardform.presentation.ui.CardFormWebViewFragment;
import com.mercadolibre.android.cardform.presentation.ui.CardFormWebViewStateFragment;
import com.mercadolibre.android.cardform.presentation.utils.ViewUtils;
import com.mercadolibre.android.cardform.presentation.viewmodel.webview.CardFormWebViewModel;
import java.util.HashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0017H\u0014J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001aH\u0014J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J \u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/mercadolibre/android/cardform/presentation/ui/CardFormWebActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "canGoBack", "", "cardFormWebContainer", "Landroid/widget/FrameLayout;", "defaultStatusBarColor", "", "progressStateContainer", "viewModel", "Lcom/mercadolibre/android/cardform/presentation/viewmodel/webview/CardFormWebViewModel;", "getViewModel", "()Lcom/mercadolibre/android/cardform/presentation/viewmodel/webview/CardFormWebViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "webViewContainer", "getStateFragment", "Lkotlin/Pair;", "Landroidx/fragment/app/Fragment;", "", "getWebViewFragment", "onBackPressed", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onSaveInstanceState", "outState", "setUpScreenComponents", "setUpViewModel", "updateScreenState", "fragment", "containerId", "fragmentTag", "Companion", "cardform_release"})
public final class CardFormWebActivity
extends AppCompatActivity {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy viewModel$delegate;
    private FrameLayout cardFormWebContainer;
    private FrameLayout progressStateContainer;
    private FrameLayout webViewContainer;
    private int defaultStatusBarColor;
    private boolean canGoBack;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(CardFormWebActivity.class), "viewModel", "getViewModel()Lcom/mercadolibre/android/cardform/presentation/viewmodel/webview/CardFormWebViewModel;"))};
        Companion = new Companion(null);
    }

    private final CardFormWebViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        CardFormWebActivity cardFormWebActivity = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (CardFormWebViewModel)((Object)lazy.getValue());
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Parcelable parcelable;
        boolean bl;
        boolean bl2;
        Object object;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_card_form_web);
        View view = this.findViewById(R.id.card_form_web);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.card_form_web)");
        this.cardFormWebContainer = (FrameLayout)view;
        View view2 = this.findViewById(R.id.web_view_fragment_container);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.web_view_fragment_container)");
        this.webViewContainer = (FrameLayout)view2;
        View view3 = this.findViewById(R.id.progress_state_fragment_container);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.progre\u2026state_fragment_container)");
        this.progressStateContainer = (FrameLayout)view3;
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
            this.defaultStatusBarColor = window.getStatusBarColor();
        }
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        if (bundle != null) {
            object = bundle;
            bl2 = false;
            bl = false;
            Bundle extras = object;
            boolean bl3 = false;
            parcelable = extras.getParcelable("card_form");
            if (parcelable == null) {
                Intrinsics.throwNpe();
            }
        } else {
            String string2 = "Card form extra should not be null";
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"extras.getParcelable<CardForm>(CARD_FORM_EXTRA)!!");
        CardForm cardFormData = (CardForm)parcelable;
        Dependencies.Companion.getInstance().initialize((Context)this, cardFormData);
        object = this.getViewModel();
        bl2 = false;
        bl = false;
        Object $this$with = object;
        boolean bl5 = false;
        if (savedInstanceState == null) {
            this.setUpScreenComponents();
            ((CardFormWebViewModel)((Object)$this$with)).showProgressStartScreen();
            ((CardFormWebViewModel)((Object)$this$with)).initInscription();
            ((CardFormWebViewModel)((Object)$this$with)).trackInit();
        } else {
            ((CardFormWebViewModel)((Object)$this$with)).recoverFromBundle(savedInstanceState);
        }
        this.setUpViewModel();
    }

    private final void setUpViewModel() {
        CardFormWebViewModel cardFormWebViewModel = this.getViewModel();
        boolean bl = false;
        boolean bl2 = false;
        CardFormWebViewModel $this$with = cardFormWebViewModel;
        boolean bl3 = false;
        LiveDataExtensionsKt.nonNullObserve($this$with.getScreenStateLiveData(), (LifecycleOwner)this, (Function1)new Function1<ScreenState, Unit>(this){
            final /* synthetic */ CardFormWebActivity this$0;
            {
                this.this$0 = cardFormWebActivity;
                super(1);
            }

            public final void invoke(@NotNull ScreenState it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ScreenState screenState = it;
                if (Intrinsics.areEqual((Object)screenState, (Object)ScreenState.ProgressState.INSTANCE)) {
                    Window window = this.this$0.getWindow();
                    if (window != null) {
                        ViewExtensionsKt.changeStatusBarColor(window, CardFormWebActivity.access$getDefaultStatusBarColor$p(this.this$0));
                    }
                    ViewExtensionsKt.visible((View)CardFormWebActivity.access$getProgressStateContainer$p(this.this$0));
                    ViewExtensionsKt.gone((View)CardFormWebActivity.access$getWebViewContainer$p(this.this$0));
                } else {
                    Window window = this.this$0.getWindow();
                    if (window != null) {
                        ViewExtensionsKt.changeStatusBarColor(window, ViewUtils.INSTANCE.getDarkPrimaryColor(ContextCompat.getColor((Context)((Context)this.this$0), (int)R.color.ui_components_android_color_primary)));
                    }
                    ViewExtensionsKt.gone((View)CardFormWebActivity.access$getProgressStateContainer$p(this.this$0));
                    ViewExtensionsKt.visible((View)CardFormWebActivity.access$getWebViewContainer$p(this.this$0));
                }
            }
        });
        LiveDataExtensionsKt.nonNullObserve($this$with.getCardResultLiveData(), (LifecycleOwner)this, (Function1)new Function1<String, Unit>($this$with, this){
            final /* synthetic */ CardFormWebViewModel $this_with;
            final /* synthetic */ CardFormWebActivity this$0;
            {
                this.$this_with = cardFormWebViewModel;
                this.this$0 = cardFormWebActivity;
                super(1);
            }

            public final void invoke(@NotNull String cardId) {
                Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
                this.this$0.setResult(-1, new Intent().putExtra("associated_card_id", cardId));
                this.$this_with.finishProcessAssociationCard();
            }
        });
        LiveDataExtensionsKt.nonNullObserve($this$with.getFinishAssociationCardLiveData(), (LifecycleOwner)this, (Function1)new Function1<Unit, Unit>($this$with, this){
            final /* synthetic */ CardFormWebViewModel $this_with;
            final /* synthetic */ CardFormWebActivity this$0;
            {
                this.$this_with = cardFormWebViewModel;
                this.this$0 = cardFormWebActivity;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$this_with.showSuccessState();
                CardFormWebActivity.access$getCardFormWebContainer$p(this.this$0).postDelayed(new Runnable(this){
                    final /* synthetic */ setUpViewModel$$inlined$with$lambda$3 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        this.this$0.this$0.finish();
                    }
                }, 1000L);
            }
        });
        LiveDataExtensionsKt.nonNullObserve($this$with.getCanGoBackViewLiveData(), (LifecycleOwner)this, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ CardFormWebActivity this$0;
            {
                this.this$0 = cardFormWebActivity;
                super(1);
            }

            public final void invoke(boolean it) {
                CardFormWebActivity.access$setCanGoBack$p(this.this$0, it);
            }
        });
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        this.getViewModel().storeInBundle(outState);
    }

    private final void setUpScreenComponents() {
        Pair<Fragment, String> pair = this.getStateFragment();
        Fragment fragment = (Fragment)pair.getFirst();
        FrameLayout frameLayout = this.progressStateContainer;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressStateContainer");
        }
        this.updateScreenState(fragment, frameLayout.getId(), (String)pair.getSecond());
        pair = this.getWebViewFragment();
        Fragment fragment2 = (Fragment)pair.getFirst();
        FrameLayout frameLayout2 = this.webViewContainer;
        if (frameLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webViewContainer");
        }
        this.updateScreenState(fragment2, frameLayout2.getId(), (String)pair.getSecond());
    }

    private final void updateScreenState(Fragment fragment, int containerId, String fragmentTag) {
        if (!fragment.isAdded()) {
            this.getSupportFragmentManager().beginTransaction().replace(containerId, fragment, fragmentTag).commitAllowingStateLoss();
        }
    }

    public void onBackPressed() {
        if (this.canGoBack) {
            this.getViewModel().trackBack();
            super.onBackPressed();
        }
    }

    private final Pair<Fragment, String> getStateFragment() {
        Fragment fragment = this.getSupportFragmentManager().findFragmentByTag("state_web_view");
        Fragment fragment2 = fragment;
        if (fragment2 == null) {
            CardFormWebActivity cardFormWebActivity = this;
            boolean bl = false;
            boolean bl2 = false;
            CardFormWebActivity it = cardFormWebActivity;
            boolean bl3 = false;
            fragment2 = CardFormWebViewStateFragment.Companion.newInstance();
        }
        fragment = fragment2;
        return TuplesKt.to((Object)fragment, (Object)"state_web_view");
    }

    private final Pair<Fragment, String> getWebViewFragment() {
        Fragment fragment = this.getSupportFragmentManager().findFragmentByTag("web_view");
        Fragment fragment2 = fragment;
        if (fragment2 == null) {
            CardFormWebActivity cardFormWebActivity = this;
            boolean bl = false;
            boolean bl2 = false;
            CardFormWebActivity it = cardFormWebActivity;
            boolean bl3 = false;
            fragment2 = CardFormWebViewFragment.Companion.newInstance();
        }
        fragment = fragment2;
        return TuplesKt.to((Object)fragment, (Object)"web_view");
    }

    protected void onDestroy() {
        super.onDestroy();
        Dependencies.Companion.getInstance().clean();
    }

    /*
     * WARNING - void declaration
     */
    public CardFormWebActivity() {
        Lazy lazy;
        Lazy lazy2;
        void $this$viewModel$iv;
        CardFormWebActivity cardFormWebActivity = this;
        CardFormWebActivity cardFormWebActivity2 = this;
        boolean $i$f$viewModel = false;
        Lazy lazyViewModelModule$iv = LazyKt.lazy((Function0)CallbackComponentExtKt.viewModel.lazyViewModelModule.1.INSTANCE);
        void var4_5 = $this$viewModel$iv;
        if (var4_5 instanceof FragmentActivity) {
            lazy2 = LazyKt.lazy((Function0)((Function0)new Function0<CardFormWebViewModel>((ComponentCallbacks)$this$viewModel$iv, lazyViewModelModule$iv){
                final /* synthetic */ ComponentCallbacks $this_viewModel;
                final /* synthetic */ Lazy $lazyViewModelModule;
                {
                    this.$this_viewModel = componentCallbacks;
                    this.$lazyViewModelModule = lazy;
                    super(0);
                }

                @NotNull
                public final CardFormWebViewModel invoke() {
                    return ((ViewModelModule)this.$lazyViewModelModule.getValue()).get((FragmentActivity)this.$this_viewModel, CardFormWebViewModel.class);
                }
            }));
        } else if (var4_5 instanceof Fragment) {
            lazy2 = LazyKt.lazy((Function0)((Function0)new Function0<CardFormWebViewModel>((ComponentCallbacks)$this$viewModel$iv, lazyViewModelModule$iv){
                final /* synthetic */ ComponentCallbacks $this_viewModel;
                final /* synthetic */ Lazy $lazyViewModelModule;
                {
                    this.$this_viewModel = componentCallbacks;
                    this.$lazyViewModelModule = lazy;
                    super(0);
                }

                @NotNull
                public final CardFormWebViewModel invoke() {
                    return ((ViewModelModule)this.$lazyViewModelModule.getValue()).get((Fragment)this.$this_viewModel, CardFormWebViewModel.class);
                }
            }));
        } else {
            String string2 = "Component must be a Fragment or FragmentActivity";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        cardFormWebActivity2.viewModel$delegate = lazy = lazy2;
    }

    public static final /* synthetic */ int access$getDefaultStatusBarColor$p(CardFormWebActivity $this) {
        return $this.defaultStatusBarColor;
    }

    public static final /* synthetic */ void access$setDefaultStatusBarColor$p(CardFormWebActivity $this, int n) {
        $this.defaultStatusBarColor = n;
    }

    public static final /* synthetic */ FrameLayout access$getProgressStateContainer$p(CardFormWebActivity $this) {
        FrameLayout frameLayout = $this.progressStateContainer;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressStateContainer");
        }
        return frameLayout;
    }

    public static final /* synthetic */ void access$setProgressStateContainer$p(CardFormWebActivity $this, FrameLayout frameLayout) {
        $this.progressStateContainer = frameLayout;
    }

    public static final /* synthetic */ FrameLayout access$getWebViewContainer$p(CardFormWebActivity $this) {
        FrameLayout frameLayout = $this.webViewContainer;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webViewContainer");
        }
        return frameLayout;
    }

    public static final /* synthetic */ void access$setWebViewContainer$p(CardFormWebActivity $this, FrameLayout frameLayout) {
        $this.webViewContainer = frameLayout;
    }

    public static final /* synthetic */ FrameLayout access$getCardFormWebContainer$p(CardFormWebActivity $this) {
        FrameLayout frameLayout = $this.cardFormWebContainer;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardFormWebContainer");
        }
        return frameLayout;
    }

    public static final /* synthetic */ void access$setCardFormWebContainer$p(CardFormWebActivity $this, FrameLayout frameLayout) {
        $this.cardFormWebContainer = frameLayout;
    }

    public static final /* synthetic */ boolean access$getCanGoBack$p(CardFormWebActivity $this) {
        return $this.canGoBack;
    }

    public static final /* synthetic */ void access$setCanGoBack$p(CardFormWebActivity $this, boolean bl) {
        $this.canGoBack = bl;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"Lcom/mercadolibre/android/cardform/presentation/ui/CardFormWebActivity$Companion;", "", "()V", "getIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "cardFormWeb", "Lcom/mercadolibre/android/cardform/internal/CardFormWeb;", "start", "", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "requestCode", "", "fragment", "Landroidx/fragment/app/Fragment;", "cardform_release"})
    public static final class Companion {
        private final Intent getIntent(Context context, CardFormWeb cardFormWeb) {
            Intent intent = new Intent(context, CardFormWebActivity.class);
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            boolean bl3 = false;
            Bundle bundle = new Bundle();
            boolean bl4 = false;
            boolean bl5 = false;
            Bundle it = bundle;
            boolean bl6 = false;
            it.putParcelable("card_form", (Parcelable)cardFormWeb);
            Bundle bundle2 = bundle;
            intent2.putExtras(bundle2);
            return intent;
        }

        public final void start(@NotNull Fragment fragment, int requestCode, @NotNull CardFormWeb cardFormWeb) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
                Intrinsics.checkParameterIsNotNull((Object)cardFormWeb, (String)"cardFormWeb");
                Context context = fragment.getContext();
                if (context == null) break block0;
                Context context2 = context;
                boolean bl = false;
                boolean bl2 = false;
                Context it = context2;
                boolean bl3 = false;
                Context context3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"it");
                fragment.startActivityForResult(Companion.getIntent(context3, cardFormWeb), requestCode);
            }
        }

        public final void start(@NotNull AppCompatActivity activity, int requestCode, @NotNull CardFormWeb cardFormWeb) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)cardFormWeb, (String)"cardFormWeb");
            activity.startActivityForResult(this.getIntent((Context)activity, cardFormWeb), requestCode);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

