/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.cardform.presentation.extensions;

import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0000\u001a\u000e\u0010\u000b\u001a\u00020\f*\u0004\u0018\u00010\u0004H\u0000\u001a\f\u0010\r\u001a\u00020\f*\u00020\u0004H\u0000\u001a\f\u0010\u000e\u001a\u00020\f*\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"PLATFORM_ML", "", "PLATFORM_MP", "getPlatform", "Landroid/content/Context;", "getPxFromDp", "", "dp", "getPxFromSp", "", "sp", "hasConnection", "", "isML", "isMP", "cardform_release"})
public final class ContextExtensionsKt {
    private static final String PLATFORM_MP = "MP";
    private static final String PLATFORM_ML = "ML";

    public static final float getPxFromDp(@NotNull Context $this$getPxFromDp, float dp) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getPxFromDp, (String)"$this$getPxFromDp");
        Resources resources = $this$getPxFromDp.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return dp * resources.getDisplayMetrics().density;
    }

    public static final int getPxFromSp(@NotNull Context $this$getPxFromSp, float sp) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getPxFromSp, (String)"$this$getPxFromSp");
        Resources resources = $this$getPxFromSp.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static final boolean hasConnection(@Nullable Context $this$hasConnection) {
        if ($this$hasConnection != null) {
            try {
                boolean haveConnectedWifi = false;
                boolean haveConnectedMobile = false;
                Object object = $this$hasConnection.getSystemService("connectivity");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
                }
                ConnectivityManager cm = (ConnectivityManager)object;
                if (Build.VERSION.SDK_INT >= 23) {
                    Network network = cm.getActiveNetwork();
                    if (network == null) {
                        return false;
                    }
                    Network nw = network;
                    NetworkCapabilities networkCapabilities = cm.getNetworkCapabilities(nw);
                    if (networkCapabilities == null) {
                        return false;
                    }
                    NetworkCapabilities actNw = networkCapabilities;
                    return actNw.hasTransport(1) ? true : actNw.hasTransport(0);
                }
                NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.isConnected()) {
                    if (networkInfo.getType() == 1 && networkInfo.isConnectedOrConnecting()) {
                        haveConnectedWifi = true;
                    }
                    if (networkInfo.getType() == 0 && networkInfo.isConnectedOrConnecting()) {
                        haveConnectedMobile = true;
                    }
                }
                return haveConnectedWifi || haveConnectedMobile;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static final boolean isML(@NotNull Context $this$isML) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isML, (String)"$this$isML");
        return Intrinsics.areEqual((Object)ContextExtensionsKt.getPlatform($this$isML), (Object)PLATFORM_ML);
    }

    public static final boolean isMP(@NotNull Context $this$isMP) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isMP, (String)"$this$isMP");
        return Intrinsics.areEqual((Object)ContextExtensionsKt.getPlatform($this$isMP), (Object)PLATFORM_MP);
    }

    @NotNull
    public static final String getPlatform(@NotNull Context $this$getPlatform) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getPlatform, (String)"$this$getPlatform");
        String string = $this$getPlatform.getApplicationInfo().packageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"applicationInfo.packageName");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"com.mercadolibre", (boolean)false, (int)2, null)) {
            return PLATFORM_ML;
        }
        return PLATFORM_MP;
    }
}

