/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.cardform.network.interceptor;

import android.content.Context;
import android.content.res.Resources;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/mercadolibre/android/cardform/network/interceptor/ScreenDensityInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getDensityName", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "cardform_release"})
public final class ScreenDensityInterceptor
implements Interceptor {
    private final Context context;
    private static final String HEADER = "x-density";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request originalRequest = chain.request();
        Request request = originalRequest.newBuilder().header(HEADER, this.getDensityName()).build();
        Response response = chain.proceed(request);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(request)");
        return response;
    }

    private final String getDensityName() {
        float densityScale = 0.00625f;
        Resources resources = this.context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density / densityScale;
        return density >= (float)640 ? "xxxhdpi" : (density >= (float)480 ? "xxhdpi" : (density >= (float)320 ? "xhdpi" : (density >= (float)240 ? "hdpi" : (density >= (float)160 ? "mdpi" : "ldpi"))));
    }

    public ScreenDensityInterceptor(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/mercadolibre/android/cardform/network/interceptor/ScreenDensityInterceptor$Companion;", "", "()V", "HEADER", "", "cardform_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

