/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.cardform.presentation.extensions;

import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b*\u0004\u0018\u00010\u0002H\u0000\u00a8\u0006\t"}, d2={"getPxFromDp", "", "Landroid/content/Context;", "dp", "getPxFromSp", "", "sp", "hasConnection", "", "cardform_release"})
public final class ContextExtensionsKt {
    public static final float getPxFromDp(@NotNull Context $this$getPxFromDp, float dp) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getPxFromDp, (String)"$this$getPxFromDp");
        Resources resources = $this$getPxFromDp.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return dp * resources.getDisplayMetrics().density;
    }

    public static final int getPxFromSp(@NotNull Context $this$getPxFromSp, float sp) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getPxFromSp, (String)"$this$getPxFromSp");
        Resources resources = $this$getPxFromSp.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static final boolean hasConnection(@Nullable Context $this$hasConnection) {
        if ($this$hasConnection != null) {
            try {
                boolean haveConnectedWifi = false;
                boolean haveConnectedMobile = false;
                Object object = $this$hasConnection.getSystemService("connectivity");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
                }
                ConnectivityManager cm = (ConnectivityManager)object;
                if (Build.VERSION.SDK_INT >= 23) {
                    Network network = cm.getActiveNetwork();
                    if (network == null) {
                        return false;
                    }
                    Network nw = network;
                    NetworkCapabilities networkCapabilities = cm.getNetworkCapabilities(nw);
                    if (networkCapabilities == null) {
                        return false;
                    }
                    NetworkCapabilities actNw = networkCapabilities;
                    return actNw.hasTransport(1) ? true : actNw.hasTransport(0);
                }
                NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.isConnected()) {
                    if (networkInfo.getType() == 1 && networkInfo.isConnectedOrConnecting()) {
                        haveConnectedWifi = true;
                    }
                    if (networkInfo.getType() == 0 && networkInfo.isConnectedOrConnecting()) {
                        haveConnectedMobile = true;
                    }
                }
                return haveConnectedWifi || haveConnectedMobile;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }
}

