/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.cardform.network.interceptor;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/mercadolibre/android/cardform/network/interceptor/LocaleInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getLocale", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "cardform_release"})
public final class LocaleInterceptor
implements Interceptor {
    private final Context context;
    private static final String HEADER = "accept-language";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request originalRequest = chain.request();
        Request request = originalRequest.newBuilder().header(HEADER, this.getLocale()).build();
        Response response = chain.proceed(request);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(request)");
        return response;
    }

    private final String getLocale() {
        Resources resources = this.context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        Configuration configuration = resources.getConfiguration();
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList locales;
            Configuration configuration2 = configuration;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
            LocaleList localeList = locales = configuration2.getLocales();
            Intrinsics.checkExpressionValueIsNotNull((Object)localeList, (String)"locales");
            if (!localeList.isEmpty()) {
                Locale locale = locales.get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"locales.get(0)");
                String string = locale.getLanguage();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locales.get(0).language");
                return string;
            }
        }
        Locale locale = configuration.locale;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"configuration.locale");
        String string = locale.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.locale.language");
        return string;
    }

    public LocaleInterceptor(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/mercadolibre/android/cardform/network/interceptor/LocaleInterceptor$Companion;", "", "()V", "HEADER", "", "cardform_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

