/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.cardform.network;

import android.content.Context;
import android.os.Build;
import com.mercadolibre.android.cardform.network.TLSSocketFactory;
import com.mercadolibre.android.cardform.network.interceptor.LocaleInterceptor;
import com.mercadolibre.android.cardform.network.interceptor.ProductIdInterceptor;
import com.mercadolibre.android.cardform.network.interceptor.ScreenDensityInterceptor;
import com.mercadolibre.android.cardform.network.interceptor.SessionInterceptor;
import com.mercadolibre.android.cardform.network.interceptor.UserAgentInterceptor;
import java.io.File;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/mercadolibre/android/cardform/network/HttpClientFactory;", "", "()V", "CACHE_DIR_NAME", "", "CACHE_SIZE", "", "LOGGING_INTERCEPTOR", "Lokhttp3/logging/HttpLoggingInterceptor$Level;", "TLS_1_2", "availableConnectionSpecs", "", "Lokhttp3/ConnectionSpec;", "certificateTrustManager", "Ljavax/net/ssl/X509TrustManager;", "configureProtocol", "Lokhttp3/OkHttpClient$Builder;", "client", "trustManager", "enableTLS12", "clientBuilder", "get", "Lokhttp3/OkHttpClient;", "context", "Landroid/content/Context;", "connectTimeout", "readTimeout", "writeTimeout", "sessionId", "getCacheDir", "Ljava/io/File;", "internalEnableTLS12", "cardform_release"})
public final class HttpClientFactory {
    private static final int CACHE_SIZE = 0xA00000;
    private static final String TLS_1_2 = "TLSv1.2";
    private static final String CACHE_DIR_NAME = "PX_OKHTTP_CACHE_SERVICES";
    private static final HttpLoggingInterceptor.Level LOGGING_INTERCEPTOR;
    public static final HttpClientFactory INSTANCE;

    @NotNull
    public final OkHttpClient get(@NotNull Context context, int connectTimeout, int readTimeout, int writeTimeout, @NotNull String sessionId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        File cacheFile = this.getCacheDir(context);
        OkHttpClient.Builder client = new OkHttpClient.Builder().connectTimeout((long)connectTimeout, TimeUnit.SECONDS).writeTimeout((long)writeTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).cache(new Cache(cacheFile, (long)0xA00000));
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        client.addInterceptor((Interceptor)new LocaleInterceptor(context2));
        client.addInterceptor((Interceptor)new UserAgentInterceptor());
        client.addInterceptor((Interceptor)new ProductIdInterceptor());
        Context context3 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context.applicationContext");
        client.addInterceptor((Interceptor)new ScreenDensityInterceptor(context3));
        client.addInterceptor((Interceptor)new SessionInterceptor(sessionId));
        HttpLoggingInterceptor loginInterceptor = new HttpLoggingInterceptor();
        loginInterceptor.setLevel(LOGGING_INTERCEPTOR);
        client.addInterceptor((Interceptor)loginInterceptor);
        OkHttpClient.Builder builder = client;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"client");
        OkHttpClient okHttpClient = this.enableTLS12(builder).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"enableTLS12(client).build()");
        return okHttpClient;
    }

    private final File getCacheDir(Context context) {
        File file = context.getCacheDir();
        if (file == null) {
            file = context.getDir("cache", 0);
        }
        File cacheDir = file;
        return new File(cacheDir, CACHE_DIR_NAME);
    }

    private final OkHttpClient.Builder enableTLS12(OkHttpClient.Builder clientBuilder) {
        return Build.VERSION.SDK_INT <= 21 ? this.internalEnableTLS12(clientBuilder) : clientBuilder;
    }

    private final OkHttpClient.Builder internalEnableTLS12(OkHttpClient.Builder client) {
        X509TrustManager certificate = this.certificateTrustManager();
        return certificate != null ? this.configureProtocol(client, certificate) : client;
    }

    private final OkHttpClient.Builder configureProtocol(OkHttpClient.Builder client, X509TrustManager trustManager) {
        try {
            SSLContext sslContext = SSLContext.getInstance(TLS_1_2);
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            SSLContext sSLContext = sslContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext, (String)"sslContext");
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            Intrinsics.checkExpressionValueIsNotNull((Object)sSLSocketFactory, (String)"sslContext.socketFactory");
            client.sslSocketFactory((SSLSocketFactory)new TLSSocketFactory(sSLSocketFactory), trustManager);
            OkHttpClient.Builder builder = client.connectionSpecs(this.availableConnectionSpecs());
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"client.connectionSpecs(availableConnectionSpecs())");
            return builder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return client;
        }
    }

    private final List<ConnectionSpec> availableConnectionSpecs() {
        ConnectionSpec connectionSpec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384}).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
        ArrayList<ConnectionSpec> connectionSpecsList = new ArrayList<ConnectionSpec>();
        connectionSpecsList.add(connectionSpec);
        connectionSpecsList.add(ConnectionSpec.CLEARTEXT);
        return connectionSpecsList;
    }

    private final X509TrustManager certificateTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManagerFactory trustManagerFactory2 = trustManagerFactory;
            Intrinsics.checkExpressionValueIsNotNull((Object)trustManagerFactory2, (String)"trustManagerFactory");
            TrustManager[] trustManagers = trustManagerFactory2.getTrustManagers();
            TrustManager trustManager = trustManagers[0];
            if (trustManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
            }
            return (X509TrustManager)trustManager;
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (KeyStoreException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    private HttpClientFactory() {
    }

    static {
        HttpClientFactory httpClientFactory;
        INSTANCE = httpClientFactory = new HttpClientFactory();
        LOGGING_INTERCEPTOR = HttpLoggingInterceptor.Level.NONE;
    }
}

