/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.cardform.di.module;

import android.arch.lifecycle.ViewModel;
import android.arch.lifecycle.ViewModelProvider;
import com.mercadolibre.android.cardform.data.model.esc.Device;
import com.mercadolibre.android.cardform.data.repository.CardAssociationRepository;
import com.mercadolibre.android.cardform.data.repository.CardRepository;
import com.mercadolibre.android.cardform.data.repository.TokenizeRepository;
import com.mercadolibre.android.cardform.di.module.BehaviourModule;
import com.mercadolibre.android.cardform.di.module.RepositoryModule;
import com.mercadolibre.android.cardform.di.module.TrackerModule;
import com.mercadolibre.android.cardform.presentation.viewmodel.InputFormViewModel;
import com.mercadopago.android.px.addons.ESCManagerBehaviour;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\u0002H\f\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/mercadolibre/android/cardform/di/module/ViewModelFactory;", "Landroid/arch/lifecycle/ViewModelProvider$Factory;", "repositoryModule", "Lcom/mercadolibre/android/cardform/di/module/RepositoryModule;", "behaviourModule", "Lcom/mercadolibre/android/cardform/di/module/BehaviourModule;", "device", "Lcom/mercadolibre/android/cardform/data/model/esc/Device;", "trackerModule", "Lcom/mercadolibre/android/cardform/di/module/TrackerModule;", "(Lcom/mercadolibre/android/cardform/di/module/RepositoryModule;Lcom/mercadolibre/android/cardform/di/module/BehaviourModule;Lcom/mercadolibre/android/cardform/data/model/esc/Device;Lcom/mercadolibre/android/cardform/di/module/TrackerModule;)V", "create", "T", "Landroid/arch/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroid/arch/lifecycle/ViewModel;", "cardform_release"})
public final class ViewModelFactory
implements ViewModelProvider.Factory {
    private final RepositoryModule repositoryModule;
    private final BehaviourModule behaviourModule;
    private final Device device;
    private final TrackerModule trackerModule;

    public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
        Intrinsics.checkParameterIsNotNull(modelClass, (String)"modelClass");
        if (modelClass.isAssignableFrom(InputFormViewModel.class)) {
            CardRepository cardRepository2 = this.repositoryModule.getCardRepository();
            TokenizeRepository tokenizeRepository2 = this.repositoryModule.getTokenizeRepository();
            CardAssociationRepository cardAssociationRepository = this.repositoryModule.getCardAssociation();
            ESCManagerBehaviour eSCManagerBehaviour = this.behaviourModule.getEscManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)eSCManagerBehaviour, (String)"behaviourModule.escManager");
            return (T)((Object)new InputFormViewModel(cardRepository2, tokenizeRepository2, cardAssociationRepository, eSCManagerBehaviour, this.device, this.trackerModule.getTracker()));
        }
        throw (Throwable)new IllegalArgumentException("Unknown ViewModel class");
    }

    public ViewModelFactory(@NotNull RepositoryModule repositoryModule, @NotNull BehaviourModule behaviourModule, @NotNull Device device, @NotNull TrackerModule trackerModule) {
        Intrinsics.checkParameterIsNotNull((Object)repositoryModule, (String)"repositoryModule");
        Intrinsics.checkParameterIsNotNull((Object)behaviourModule, (String)"behaviourModule");
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Intrinsics.checkParameterIsNotNull((Object)trackerModule, (String)"trackerModule");
        this.repositoryModule = repositoryModule;
        this.behaviourModule = behaviourModule;
        this.device = device;
        this.trackerModule = trackerModule;
    }
}

