/*
 * Decompiled with CFR 0.152.
 */
package com.mercadolibre.android.cardform.data.model.esc;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import com.mercadolibre.android.cardform.data.model.esc.VendorSpecificAttributes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0002'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010#\u001a\u00020\u0006H\u0002J\b\u0010$\u001a\u00020\u0006H\u0002J\u000f\u0010%\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010&\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0019\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lcom/mercadolibre/android/cardform/data/model/esc/Fingerprint;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "diskSpace", "", "getDiskSpace", "()J", "freeDiskSpace", "getFreeDiskSpace", "model", "", "getModel", "()Ljava/lang/String;", "os", "getOs", "ram", "getRam", "()Ljava/lang/Long;", "Ljava/lang/Long;", "resolution", "getResolution", "systemVersion", "kotlin.jvm.PlatformType", "getSystemVersion", "vendorIds", "", "Lcom/mercadolibre/android/cardform/data/model/esc/Fingerprint$VendorId;", "getVendorIds", "()Ljava/util/List;", "vendorSpecificAttributes", "Lcom/mercadolibre/android/cardform/data/model/esc/VendorSpecificAttributes;", "getVendorSpecificAttributes", "()Lcom/mercadolibre/android/cardform/data/model/esc/VendorSpecificAttributes;", "getDeviceDiskSpace", "getDeviceFreeDiskSpace", "getDeviceRam", "getDeviceResolution", "SecureRandomId", "VendorId", "cardform_release"})
public final class Fingerprint {
    @NotNull
    private final List<VendorId> vendorIds;
    @Nullable
    private final String model;
    @NotNull
    private final String os = "android";
    private final String systemVersion;
    @NotNull
    private final String resolution;
    @Nullable
    private final Long ram;
    private final long diskSpace;
    private final long freeDiskSpace;
    @NotNull
    private final VendorSpecificAttributes vendorSpecificAttributes;

    @NotNull
    public final List<VendorId> getVendorIds() {
        return this.vendorIds;
    }

    @Nullable
    public final String getModel() {
        return this.model;
    }

    @NotNull
    public final String getOs() {
        return this.os;
    }

    public final String getSystemVersion() {
        return this.systemVersion;
    }

    @NotNull
    public final String getResolution() {
        return this.resolution;
    }

    @Nullable
    public final Long getRam() {
        return this.ram;
    }

    public final long getDiskSpace() {
        return this.diskSpace;
    }

    public final long getFreeDiskSpace() {
        return this.freeDiskSpace;
    }

    @NotNull
    public final VendorSpecificAttributes getVendorSpecificAttributes() {
        return this.vendorSpecificAttributes;
    }

    private final List<VendorId> getVendorIds(Context context) {
        String randomId;
        String androidId;
        ArrayList<VendorId> vendorIds = new ArrayList<VendorId>();
        String string = androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"androidId");
        vendorIds.add(new VendorId("android_id", string));
        if (!TextUtils.isEmpty((CharSequence)Build.SERIAL) && Intrinsics.areEqual((Object)"unknown", (Object)Build.SERIAL) ^ true) {
            String string2 = Build.SERIAL;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Build.SERIAL");
            vendorIds.add(new VendorId("serial", string2));
        }
        if (!TextUtils.isEmpty((CharSequence)(randomId = SecureRandomId.INSTANCE.getValue(context)))) {
            String string3 = randomId;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            vendorIds.add(new VendorId("fsuuid", string3));
        }
        return vendorIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final Long getDeviceRam() {
        Long ram;
        block13: {
            RandomAccessFile reader;
            block12: {
                ram = null;
                reader = null;
                reader = new RandomAccessFile("/proc/meminfo", "r");
                String load = reader.readLine();
                Pattern pattern = Pattern.compile("(\\d+)");
                Matcher matcher = pattern.matcher(load);
                if (!matcher.find()) break block12;
                ram = Long.valueOf(matcher.group(0));
            }
            try {
                reader.close();
            }
            catch (Exception exception) {}
            break block13;
            catch (Exception exception) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception2) {}
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        return ram;
    }

    private final long getDeviceDiskSpace() {
        File file = Environment.getDataDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getDataDirectory()");
        StatFs statFs = new StatFs(file.getPath());
        return (long)statFs.getBlockSize() * (long)statFs.getBlockCount() / (long)0x100000;
    }

    private final long getDeviceFreeDiskSpace() {
        File file = Environment.getDataDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getDataDirectory()");
        StatFs statFs = new StatFs(file.getPath());
        return (long)statFs.getBlockSize() * (long)statFs.getAvailableBlocks() / (long)0x100000;
    }

    private final String getDeviceResolution(Context context) {
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager manager = (WindowManager)object;
        Display display = manager.getDefaultDisplay();
        StringBuilder stringBuilder = new StringBuilder();
        Display display2 = display;
        Intrinsics.checkExpressionValueIsNotNull((Object)display2, (String)"display");
        return stringBuilder.append(String.valueOf(display2.getWidth())).append("x").append(display.getHeight()).toString();
    }

    public Fingerprint(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.vendorIds = this.getVendorIds(context);
        this.model = Build.MODEL;
        this.os = "android";
        this.systemVersion = Build.VERSION.RELEASE;
        this.resolution = this.getDeviceResolution(context);
        this.ram = this.getDeviceRam();
        this.diskSpace = this.getDeviceDiskSpace();
        this.freeDiskSpace = this.getDeviceFreeDiskSpace();
        this.vendorSpecificAttributes = new VendorSpecificAttributes(context);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/mercadolibre/android/cardform/data/model/esc/Fingerprint$SecureRandomId;", "", "()V", "FILENAME_FSUUID", "", "fSUUID", "getValue", "context", "Landroid/content/Context;", "readFile", "file", "Ljava/io/File;", "writeFile", "", "cardform_release"})
    private static final class SecureRandomId {
        private static final String FILENAME_FSUUID = "fsuuid";
        private static String fSUUID;
        public static final SecureRandomId INSTANCE;

        private final String readFile(File file) throws IOException {
            RandomAccessFile f = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            f.close();
            boolean bl = false;
            return new String(bytes, Charsets.UTF_8);
        }

        private final void writeFile(File file) throws IOException {
            String id;
            FileOutputStream out = new FileOutputStream(file);
            SecureRandom random = new SecureRandom();
            String string = id = new BigInteger(64, random).toString(16);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            String string2 = string;
            FileOutputStream fileOutputStream = out;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            fileOutputStream.write(byArray2);
            out.close();
        }

        @Nullable
        public final synchronized String getValue(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (fSUUID == null) {
                File file = Environment.getExternalStorageDirectory();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalStorageDirectory()");
                String path = file.getAbsolutePath();
                File file2 = new File(path + "/" + context.getPackageName(), FILENAME_FSUUID);
                try {
                    boolean dirs;
                    if (!file2.exists() && (dirs = file2.getParentFile().mkdirs())) {
                        this.writeFile(file2);
                    }
                    fSUUID = this.readFile(file2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return fSUUID;
        }

        private SecureRandomId() {
        }

        static {
            SecureRandomId secureRandomId;
            INSTANCE = secureRandomId = new SecureRandomId();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/mercadolibre/android/cardform/data/model/esc/Fingerprint$VendorId;", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "cardform_release"})
    public static final class VendorId {
        @NotNull
        private final String name;
        @NotNull
        private final String value;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public VendorId(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.name = name;
            this.value = value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final VendorId copy(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new VendorId(name, value);
        }

        public static /* synthetic */ VendorId copy$default(VendorId vendorId, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = vendorId.name;
            }
            if ((n & 2) != 0) {
                string2 = vendorId.value;
            }
            return vendorId.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "VendorId(name=" + this.name + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.value;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof VendorId)) break block3;
                    VendorId vendorId = (VendorId)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)vendorId.name) || !Intrinsics.areEqual((Object)this.value, (Object)vendorId.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

