/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.webservices;

import com.meniga.sdk.helpers.KeyVal;
import com.meniga.sdk.models.categories.MenigaCategory;
import com.meniga.sdk.models.categories.MenigaUserCategory;
import com.meniga.sdk.models.feed.MenigaFeed;
import com.meniga.sdk.models.feed.MenigaFeedItem;
import com.meniga.sdk.models.feed.MenigaScheduledEvent;
import com.meniga.sdk.models.merchants.MenigaMerchant;
import com.meniga.sdk.models.merchants.MenigaTopMerchant;
import com.meniga.sdk.models.networth.MenigaNetWorth;
import com.meniga.sdk.models.networth.MenigaNetWorthBalance;
import com.meniga.sdk.models.organizations.MenigaOrganization;
import com.meniga.sdk.models.organizations.MenigaRealmAccount;
import com.meniga.sdk.models.organizations.MenigaRealmAuthResponse;
import com.meniga.sdk.models.serverpublic.MenigaPublicSettings;
import com.meniga.sdk.models.sync.MenigaSync;
import com.meniga.sdk.models.sync.MenigaSyncStatus;
import com.meniga.sdk.models.terms.MenigaTermType;
import com.meniga.sdk.models.terms.MenigaTerms;
import com.meniga.sdk.models.transactions.MenigaComment;
import com.meniga.sdk.models.transactions.MenigaTag;
import com.meniga.sdk.models.transactions.MenigaTransaction;
import com.meniga.sdk.models.transactions.MenigaTransactionPage;
import com.meniga.sdk.models.transactions.MenigaTransactionRule;
import com.meniga.sdk.models.transactions.MenigaTransactionSeries;
import com.meniga.sdk.models.transactions.MenigaTransactionUpdate;
import com.meniga.sdk.models.upcoming.MenigaUpcoming;
import com.meniga.sdk.models.userevents.MenigaUserEvent;
import com.meniga.sdk.webservices.requests.AddComments;
import com.meniga.sdk.webservices.requests.CreateComment;
import com.meniga.sdk.webservices.requests.CreateNetWorthAccount;
import com.meniga.sdk.webservices.requests.CreateNetWorthBalanceHistory;
import com.meniga.sdk.webservices.requests.CreateTransaction;
import com.meniga.sdk.webservices.requests.CreateTransactionRule;
import com.meniga.sdk.webservices.requests.CreateUpcoming;
import com.meniga.sdk.webservices.requests.CreateUserCategory;
import com.meniga.sdk.webservices.requests.GetRealmAuthMethod;
import com.meniga.sdk.webservices.requests.GetTopMerchants;
import com.meniga.sdk.webservices.requests.GetTransactionSeries;
import com.meniga.sdk.webservices.requests.RecategorizeTransactions;
import com.meniga.sdk.webservices.requests.SetSubscription;
import com.meniga.sdk.webservices.requests.SetSubscriptionSettings;
import com.meniga.sdk.webservices.requests.SplitTransaction;
import com.meniga.sdk.webservices.requests.StartRealmSync;
import com.meniga.sdk.webservices.requests.StartSync;
import com.meniga.sdk.webservices.requests.UpdateComment;
import com.meniga.sdk.webservices.requests.UpdateHistoryBalance;
import com.meniga.sdk.webservices.requests.UpdateSplits;
import com.meniga.sdk.webservices.requests.UpdateTransaction;
import com.meniga.sdk.webservices.requests.UpdateTransactionRule;
import com.meniga.sdk.webservices.requests.UpdateTransactions;
import com.meniga.sdk.webservices.requests.UpdateUpcoming;
import com.meniga.sdk.webservices.requests.UpdateUserCategory;
import com.meniga.sdk.webservices.requests.UpdatedNetWorthAccount;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.Header;
import retrofit2.http.HeaderMap;
import retrofit2.http.OPTIONS;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;
import retrofit2.http.Url;

public interface MenigaAPI {
    @GET(value="merchants/{id}")
    public Call<MenigaMerchant> getMerchant(@Path(value="id") long var1);

    @GET(value="merchants")
    public Call<List<MenigaMerchant>> getMerchants(@QueryMap Map<String, String> var1);

    @POST(value="merchants/top")
    public Call<List<MenigaTopMerchant>> getTopMerchants(@Body GetTopMerchants var1);

    @DELETE(value="transactions")
    public Call<Void> deleteTransactions(@QueryMap Map<String, String> var1);

    @GET(value="transactions")
    public Call<MenigaTransactionPage> getTransactions(@QueryMap Map<String, String> var1);

    @POST(value="transactions")
    public Call<MenigaTransaction> createTransaction(@Body CreateTransaction var1);

    @PUT(value="transactions")
    public Call<MenigaTransactionUpdate> updateTransactions(@QueryMap Map<String, String> var1, @Body UpdateTransactions var2);

    @GET(value="transactions/{id}?include=Account,Merchant")
    public Call<MenigaTransaction> getTransaction(@Path(value="id") long var1);

    @PUT(value="transactions/{id}")
    public Call<MenigaTransactionUpdate> updateTransaction(@Path(value="id") long var1, @Body UpdateTransaction var3);

    @DELETE(value="transactions/{id}")
    public Call<Void> deleteTransaction(@Path(value="id") long var1);

    @POST(value="transactions/series")
    public Call<List<MenigaTransactionSeries>> getTransactionSeries(@Body GetTransactionSeries var1);

    @POST(value="transactions/{id}/comments")
    public Call<MenigaComment> createComment(@Path(value="id") long var1, @Body CreateComment var3);

    @PUT(value="transactions/{id}/comments/{commentId}")
    public Call<Void> updateComment(@Path(value="id") long var1, @Path(value="commentId") long var3, @Body UpdateComment var5);

    @DELETE(value="transactions/{id}/comments/{commentId}")
    public Call<Void> deleteComment(@Path(value="id") long var1, @Path(value="commentId") long var3);

    @POST(value="transactions/comments")
    public Call<List<MenigaComment>> addComments(@Body AddComments var1);

    @GET(value="transactions/{id}/split")
    public Call<List<MenigaTransaction>> fetchSplitTransactions(@Path(value="id") long var1);

    @POST(value="transactions/{id}/split")
    public Call<List<MenigaTransaction>> splitTransaction(@Path(value="id") long var1, @Body SplitTransaction var3);

    @PUT(value="transactions/{id}/split")
    public Call<List<MenigaTransaction>> updateSplits(@Path(value="id") long var1, @Body List<UpdateSplits> var3);

    @POST(value="transactions/recategorize")
    public Call<Void> recategorizeTransactions(@Body RecategorizeTransactions var1);

    @GET(value="transactions/rules")
    public Call<List<MenigaTransactionRule>> getTransactionRules();

    @POST(value="transactions/rules")
    public Call<MenigaTransactionRule> createTransactionRule(@QueryMap Map<String, String> var1, @Body CreateTransactionRule var2);

    @DELETE(value="transactions/rules/{id}")
    public Call<Void> deleteTransactionRule(@Path(value="id") long var1);

    @GET(value="transactions/rules/{id}")
    public Call<MenigaTransactionRule> getTransactionRule(@Path(value="id") long var1);

    @PUT(value="transactions/rules/{id}")
    public Call<Void> updateTransactionRule(@Path(value="id") long var1, @QueryMap Map<String, String> var3, @Body UpdateTransactionRule var4);

    @GET(value="tags")
    public Call<List<MenigaTag>> getTags();

    @GET(value="tags/{id}")
    public Call<MenigaTag> getTag(@Path(value="id") long var1);

    @POST(value="sync")
    public Call<MenigaSync> startSync(@Body StartSync var1);

    @POST(value="sync/realm/{id}")
    public Call<MenigaSync> startRealmSync(@Body StartRealmSync var1, @Path(value="id") long var2);

    @GET(value="sync")
    public Call<MenigaSyncStatus> getSyncStatus();

    @GET(value="sync/{id}")
    public Call<MenigaSync> getSync(@Path(value="id") long var1);

    @POST(value="sync/realm/{id}/auth")
    public Call<MenigaRealmAuthResponse> getRealmAuthMethod(@Path(value="id") long var1, @Body GetRealmAuthMethod var3);

    @GET(value="sync/accounts/{id}")
    public Call<List<MenigaRealmAccount>> getRealmAccounts(@Path(value="id") long var1, @QueryMap Map<String, String> var3);

    @POST(value="sync/accounts/{id}/authorize")
    public Call<List<MenigaRealmAccount>> addRealmAccountsToMeniga(@Path(value="id") long var1, @Body List<MenigaRealmAccount> var3, @QueryMap Map<String, String> var4);

    @GET(value="userevents/subscription/details")
    public Call<List<MenigaUserEvent>> getUserEvents();

    @PUT(value="userevents/subscription")
    public Call<Void> setSubscription(@Body SetSubscription var1);

    @PUT(value="userevents/subscription/details")
    public Call<Void> updateSettings(@Body SetSubscriptionSettings var1);

    @GET(value="feed?include=Account,Merchant")
    public Call<MenigaFeed> getFeed(@QueryMap Map<String, String> var1);

    @GET(value="feed/{type}/{id}")
    public Call<MenigaScheduledEvent> getScheduledEvent(@Path(value="type") String var1, @Path(value="id") long var2);

    @GET(value="userevents/{id}")
    public Call<MenigaFeedItem> getEvent(@Path(value="id") long var1);

    @GET(value="categories")
    public Call<List<MenigaCategory>> getCategories(@QueryMap Map<String, String> var1);

    @GET(value="categories/{id}")
    public Call<MenigaCategory> getCategoryById(@Path(value="id") long var1, @QueryMap Map<String, String> var3);

    @POST(value="categories")
    public Call<MenigaUserCategory> createUserCategory(@Body CreateUserCategory var1);

    @DELETE(value="categories/{id}")
    public Call<Void> deleteCategory(@Path(value="id") long var1, @QueryMap Map<String, String> var3);

    @PUT(value="categories/{id}")
    public Call<Void> updateUserCategory(@Path(value="id") long var1, @Body UpdateUserCategory var3);

    @GET(value="networth/accounts/{id}")
    public Call<MenigaNetWorth> getNetWorth(@Path(value="id") long var1);

    @GET(value="networth")
    public Call<List<MenigaNetWorth>> getNetWorths(@QueryMap Map<String, String> var1);

    @PUT(value="networth/accounts/{id}/balancehistory/{historyid}")
    public Call<Void> updateBalance(@Path(value="id") long var1, @Path(value="historyid") long var3, @Body UpdateHistoryBalance var5);

    @DELETE(value="networth/accounts/{id}/balancehistory/{historyid}")
    public Call<Void> deleteBalance(@Path(value="id") long var1, @Path(value="historyid") long var3);

    @GET(value="networth/first")
    public Call<MenigaNetWorthBalance> getNetWorthFirstBalanceEntry(@QueryMap Map<String, String> var1);

    @POST(value="networth/accounts")
    public Call<MenigaNetWorth> createNetWorthAccount(@Body CreateNetWorthAccount var1);

    @DELETE(value="networth/accounts/{id}")
    public Call<Void> deleteNetWorthAccount(@Path(value="id") long var1);

    @PUT(value="networth/accounts/{id}")
    public Call<Void> updateNetWorthAccount(@Path(value="id") long var1, @Body UpdatedNetWorthAccount var3);

    @POST(value="networth/accounts/{id}/balancehistory")
    public Call<MenigaNetWorthBalance> createNetWorthBalanceHistory(@Path(value="id") long var1, @Body CreateNetWorthBalanceHistory var3);

    @GET(value="networth/types")
    public Call<List<KeyVal<Long, String>>> getNetWorthTypes();

    @GET(value="public/settings")
    public Call<MenigaPublicSettings> getPublicSettings();

    @GET(value="terms")
    public Call<List<MenigaTerms>> getTerms(@Header(value="Accept-Language") String var1);

    @GET(value="terms/{typeId}")
    public Call<MenigaTerms> getTerm(@Header(value="Accept-Language") String var1, @Path(value="typeId") long var2);

    @GET(value="terms/types")
    public Call<List<MenigaTermType>> getTermTypes(@Header(value="Accept-Language") String var1);

    @POST(value="terms/{typeId}/accept")
    public Call<Void> acceptTerms(@Path(value="typeId") long var1);

    @POST(value="terms/{typeId}/decline")
    public Call<Void> declineTerms(@Path(value="typeId") long var1);

    @GET(value="upcoming")
    public Call<List<MenigaUpcoming>> getUpcoming(@QueryMap Map<String, String> var1);

    @GET(value="upcoming/{id}")
    public Call<MenigaUpcoming> getUpcoming(@Path(value="id") long var1);

    @POST(value="upcoming")
    public Call<List<MenigaUpcoming>> createUpcoming(@Body CreateUpcoming var1);

    @PUT(value="upcoming/{id}")
    public Call<Void> updateUpcoming(@Path(value="id") long var1, @Body UpdateUpcoming var3, @QueryMap Map<String, String> var4);

    @DELETE(value="upcoming/{id}")
    public Call<Void> deleteUpcoming(@Path(value="id") long var1);

    @DELETE(value="upcoming/recurring/{id}")
    public Call<Void> deleteUpcomingSeries(@Path(value="id") long var1);

    @POST(value="upcoming/{id}/reconcile/{entityType}/{entityId}")
    public Call<Void> reconcileUpcoming(@Path(value="id") long var1, @Path(value="entityType") String var3, @Path(value="entityId") long var4);

    @GET(value="organizations")
    public Call<List<MenigaOrganization>> getOrganizations();

    @GET
    public Call<Object> genericGet(@Url String var1, @HeaderMap Map<String, String> var2, @QueryMap Map<String, String> var3);

    @HEAD
    public Call<Object> genericHead(@Url String var1, @HeaderMap Map<String, String> var2, @QueryMap Map<String, String> var3);

    @OPTIONS
    public Call<Object> genericOptions(@Url String var1, @HeaderMap Map<String, String> var2, @QueryMap Map<String, String> var3);

    @POST
    public Call<Object> genericPost(@Url String var1, @HeaderMap Map<String, String> var2, @Body Object var3, @QueryMap Map<String, String> var4);

    @PUT
    public Call<Object> genericPut(@Url String var1, @HeaderMap Map<String, String> var2, @Body Object var3, @QueryMap Map<String, String> var4);

    @DELETE
    public Call<Object> genericDelete(@Url String var1, @HeaderMap Map<String, String> var2, @QueryMap Map<String, String> var3);
}

